// ignore_for_file: must_be_immutable, sized_box_for_whitespace

import 'package:byod/helper/widget/plus_minus_button.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/order_bloc.dart';
import '../../bloc/order_detail_variant.dart';
import '../../bloc/order_variant_temporary.dart';
import '../../helper/helper.dart';
import '../../helper/widget/button_modal.dart';
import '../../main.dart';
import '../../models/order_details.dart';
import '../../models/orders.dart';
import '../../models/variant_categories.dart';
import 'variant_cat_new.dart';

class CustomizeVariantNew extends StatefulWidget {
  CustomizeVariantNew({
    super.key,
    required this.orders,
    required this.variantCat,
  });

  Orders orders;
  List<VariantCategories> variantCat;

  @override
  State<CustomizeVariantNew> createState() => _CustomizeVariantNewState();
}

class _CustomizeVariantNewState extends State<CustomizeVariantNew> {
  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    return Container(
      // width: widthScreen,
      height: MediaQuery.of(context).size.height * 0.7,
      decoration: const BoxDecoration(
        borderRadius: BorderRadius.only(
          topLeft: Radius.circular(19),
          topRight: Radius.circular(19),
        ),
        color: backgroundWhite,
      ),
      child: BlocBuilder<OrdersBloc, List<Orders>>(
        builder: (context, listCurrentOrder) {
          int indexOrders =
              listCurrentOrder.indexWhere((value) => value == widget.orders);
          if (indexOrders == -1) {
            Navigator.pop(context);
          }
          return Stack(
            children: [
              Container(
                padding:
                    const EdgeInsets.symmetric(horizontal: paddingLeftRight),
                child: Column(
                  mainAxisSize: MainAxisSize.min,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    const SizedBox(
                      height: 8,
                    ),
                    Center(
                      child: Container(
                        width: 50,
                        height: 3,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(7),
                          color: disabledColor,
                        ),
                      ),
                    ),
                    const SizedBox(
                      height: 28,
                    ),
                    defaultText(
                      context,
                      widget.orders.namaMenu,
                      maxLines: 2,
                      overFlow: TextOverflow.ellipsis,
                      style: textStyleVariantModal(
                        font: 20,
                        fontWeight: FontWeight.w600,
                      ),
                    ),
                    const SizedBox(
                      height: 12,
                    ),
                    Expanded(
                      child: ListView.builder(
                          itemCount: widget.orders.orderDetail.length,
                          itemBuilder: (context, i) {
                            int totalHarga =
                                widget.orders.orderDetail[i].totalHarga.toInt();
                            int totalItem =
                                widget.orders.orderDetail[i].totalItem.toInt();
                            int satuanHarga = totalHarga ~/ totalItem;
                            List<String> variantCaption = [''];
                            List<String> variantName = [''];
                            for (int y = 0;
                                y <
                                    widget.orders.orderDetail[i].orderVariant
                                        .length;
                                y++) {
                              int indexCaption = variantCaption.indexWhere(
                                  (element) =>
                                      element ==
                                      widget.orders.orderDetail[i]
                                          .orderVariant[y].caption);
                              if (indexCaption == -1) {
                                variantCaption.add(widget.orders.orderDetail[i]
                                    .orderVariant[y].caption);
                                variantName.add(widget.orders.orderDetail[i]
                                    .orderVariant[y].name);
                              } else {
                                variantName[indexCaption] +=
                                    ", ${widget.orders.orderDetail[i].orderVariant[y].name}";
                              }
                            }
                            return Column(
                              children: [
                                Row(
                                  crossAxisAlignment: CrossAxisAlignment.end,
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Container(
                                          padding:
                                              const EdgeInsets.only(bottom: 8),
                                          child: defaultText(
                                            context,
                                            "Rp ${formatNumber().format(widget.orders.orderDetail[i].totalHarga)}",
                                            maxLines: 1,
                                            overFlow: TextOverflow.ellipsis,
                                            style: textStyleVariantModal(
                                              fontWeight: FontWeight.w600,
                                            ),
                                          ),
                                        ),
                                        Column(
                                          mainAxisSize: MainAxisSize.min,
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            for (int d = 0;
                                                d < variantCaption.length;
                                                d++)
                                              if (variantCaption[d] != '')
                                                Row(
                                                  children: [
                                                    defaultText(
                                                      context,
                                                      "${variantCaption[d]} : ",
                                                      maxLines: 2,
                                                      overFlow:
                                                          TextOverflow.ellipsis,
                                                      style:
                                                          textStyleVariantModal(),
                                                    ),
                                                    defaultText(
                                                      context,
                                                      variantName[d],
                                                      maxLines: 2,
                                                      overFlow:
                                                          TextOverflow.ellipsis,
                                                      style:
                                                          textStyleVariantModal(),
                                                    ),
                                                  ],
                                                )
                                          ],
                                        ),
                                        (widget.orders.orderDetail[i].note !=
                                                '')
                                            ? Container(
                                                padding: const EdgeInsets.only(
                                                  bottom: 8,
                                                  top: 8,
                                                ),
                                                child: defaultText(
                                                  context,
                                                  'Catatan: ${widget.orders.orderDetail[i].note}',
                                                  maxLines: 3,
                                                  overFlow:
                                                      TextOverflow.ellipsis,
                                                  style:
                                                      textStyleVariantModal(),
                                                ),
                                              )
                                            : const SizedBox()
                                      ],
                                    ),
                                    Stack(
                                      children: [
                                        Container(
                                          width: 94,
                                          height: 22,
                                          decoration: BoxDecoration(
                                            borderRadius:
                                                BorderRadius.circular(30),
                                            color: backgroundColor,
                                          ),
                                          child: Center(
                                            child: defaultText(
                                              context,
                                              widget.orders.orderDetail[i]
                                                  .totalItem
                                                  .toString(),
                                              style: amountViewBillButton(),
                                            ),
                                          ),
                                        ),
                                        Positioned(
                                          left: 0,
                                          child: GestureDetector(
                                            onTap: () {
                                              OrderDetail orderDetailNow =
                                                  OrderDetail(
                                                allIdVariant: widget
                                                    .orders
                                                    .orderDetail[i]
                                                    .allIdVariant,
                                                totalItem: widget
                                                        .orders
                                                        .orderDetail[i]
                                                        .totalItem -
                                                    1,
                                                totalHarga: widget
                                                        .orders
                                                        .orderDetail[i]
                                                        .totalHarga -
                                                    satuanHarga,
                                                note: widget
                                                    .orders.orderDetail[i].note,
                                                orderVariant: widget
                                                    .orders
                                                    .orderDetail[i]
                                                    .orderVariant,
                                              );
                                              Map<String, dynamic> insertData =
                                                  {
                                                'action': 'editVariant',
                                                'list_orders': listCurrentOrder,
                                                'single_order_detail':
                                                    orderDetailNow,
                                              };
                                              context
                                                  .read<OrdersBloc>()
                                                  .insertData(insertData);
                                              setState(() {});
                                            },
                                            child: Container(
                                              width: 22,
                                              height: 22,
                                              child: Image(
                                                image: AssetImage((isExcelso)
                                                    ? 'assets/icons/minus-gold.png'
                                                    : 'assets/icons/minus-blue.png'),
                                              ),
                                            ),
                                          ),
                                        ),
                                        Positioned(
                                          right: 0,
                                          child: GestureDetector(
                                            onTap: () {
                                              OrderDetail orderDetailNow =
                                                  OrderDetail(
                                                allIdVariant: widget
                                                    .orders
                                                    .orderDetail[i]
                                                    .allIdVariant,
                                                totalItem: widget
                                                        .orders
                                                        .orderDetail[i]
                                                        .totalItem +
                                                    1,
                                                totalHarga: widget
                                                        .orders
                                                        .orderDetail[i]
                                                        .totalHarga +
                                                    satuanHarga,
                                                note: widget
                                                    .orders.orderDetail[i].note,
                                                orderVariant: widget
                                                    .orders
                                                    .orderDetail[i]
                                                    .orderVariant,
                                              );
                                              Map<String, dynamic> insertData =
                                                  {
                                                'action': 'editVariant',
                                                'list_orders': listCurrentOrder,
                                                'single_order_detail':
                                                    orderDetailNow,
                                              };
                                              context
                                                  .read<OrdersBloc>()
                                                  .insertData(insertData);
                                              setState(() {});
                                              // context
                                              //     .read<OrderDetailVariant>()
                                              //     .orderDetail(
                                              //         orders.orderDetail[i]
                                              //             .allIdVariant,
                                              //         orders.orderDetail[i]
                                              //                 .totalItem +
                                              //             1,
                                              //         orders.orderDetail[i]
                                              //                 .totalHarga +
                                              //             satuanHarga,
                                              //         orders
                                              //             .orderDetail[i].note,
                                              //         orders.orderDetail[i]
                                              //             .orderVariant,
                                              //         context,
                                              //         orders,
                                              //         listCurrentOrder);
                                              // orders.orderDetail[i].totalItem +
                                              //     1;
                                              // orders.orderDetail[i].totalHarga +
                                              //     satuanHarga;
                                            },
                                            child: Container(
                                              width: 22,
                                              height: 22,
                                              child: Image(
                                                image: AssetImage((isExcelso)
                                                    ? 'assets/icons/plus-gold.png'
                                                    : 'assets/icons/plus.png'),
                                              ),
                                            ),
                                          ),
                                        )
                                      ],
                                    ),
                                  ],
                                ),
                                const SizedBox(
                                  height: 12,
                                ),
                                (i != widget.orders.orderDetail.length - 1)
                                    ? const Divider(
                                        thickness: 1,
                                        height: 1,
                                        color: dividerGrey,
                                      )
                                    : const SizedBox(),
                                (i != widget.orders.orderDetail.length - 1)
                                    ? const SizedBox(
                                        height: 16,
                                      )
                                    : const SizedBox(),
                                (i == widget.orders.orderDetail.length - 1)
                                    ? const SizedBox(
                                        height: 65,
                                      )
                                    : const SizedBox()
                              ],
                            );
                          }),
                    )
                  ],
                ),
              ),
              Positioned(
                bottom: 0,
                child: Container(
                  height: 59,
                  width: MediaQuery.of(context).size.width,
                  padding: const EdgeInsets.only(
                    left: paddingLeftRight,
                    right: paddingLeftRight,
                    bottom: 16,
                  ),
                  color: backgroundWhite,
                  child: GestureDetector(
                    onTap: () {
                      Navigator.pop(context);
                      Navigator.push(
                        context,
                        MaterialPageRoute(
                          builder: (_) => VariantCatNew(
                            initPrice: widget.orders.satuanHarga,
                            variantCategories: widget.variantCat,
                            namaMenu: widget.orders.namaMenu,
                            idItem: widget.orders.id,
                            imageUrl: widget.orders.imageUrl,
                            listCurrentOrder: listCurrentOrder,
                          ),
                        ),
                      );
                    },
                    child: Container(
                      height: 43,
                      width: double.infinity,
                      decoration: BoxDecoration(
                        color: buttonColor,
                        borderRadius: BorderRadius.circular(48),
                      ),
                      child: Center(
                        child: defaultText(
                          context,
                          'Tambah Variant',
                          style: addButton(),
                        ),
                      ),
                    ),
                  ),
                ),
              )
            ],
          );
        },
      ),
    );
  }
}
// Positioned(
//           bottom: 0,
//           child: ButtonComponent(
//               buttonColor: buttonColor, teksButton: 'Tambah Variant'),
//         )