// ignore_for_file: must_be_immutable

import 'package:byod/bloc/menu_selected_bar.dart';
import 'package:byod/models/fav_group.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/search_active.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../models/category_list.dart';

class CategoryListHome extends StatefulWidget {
  List<CategoryList> categoryList;
  List<FavoriteGroup> favList;
  ScrollController scrollController;
  // ScrollController scrollControllerMenu;
  CategoryListHome({
    Key? key,
    required this.categoryList,
    required this.scrollController,
    required this.favList,
    // required this.scrollControllerMenu,
  }) : super(key: key);

  @override
  State<CategoryListHome> createState() => _CategoryListHomeState();
}

class _CategoryListHomeState extends State<CategoryListHome> {
  int selectedIndex = 0;

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<MenuSelectedBar, Map<String, dynamic>>(
      builder: (contextMenuSelectedBar, selectedBarIndex) {
        selectedIndex = selectedBarIndex['index'];
        return ListView.builder(
          scrollDirection: Axis.horizontal,
          itemCount: widget.categoryList.length,
          itemBuilder: (context, i) {
            return GestureDetector(
              onTap: () {
                FocusScopeNode currentFocus = FocusScope.of(context);

                if (!currentFocus.hasPrimaryFocus) {
                  currentFocus.unfocus();
                }
                context.read<SearchActive>().searchClick(true);
                context
                    .read<MenuSelectedBar>()
                    .selectedBarMenu(i, widget.categoryList[i].id);
                widget.scrollController.animateTo(
                  (widget.favList.isNotEmpty)
                      ? heighScrollWithImage
                      : imageHeight, // 371 sudah dihituing pixelnya untuk awal banget dari menu item
                  duration: const Duration(milliseconds: 500),
                  curve: Curves.fastOutSlowIn,
                );
              },
              child: Container(
                color: backgroundColor,
                margin: EdgeInsets.only(
                    left: (i == 0) ? 0 : 28.335,
                    right: (i == widget.categoryList.length - 1) ? 0 : 28.335),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    AnimatedSwitcher(
                      duration: Duration(milliseconds: animatedTime),
                      transitionBuilder:
                          (Widget child, Animation<double> animation) {
                        return ScaleTransition(scale: animation, child: child);
                      },
                      child: Container(
                        key: const Key('underline'),
                        padding: const EdgeInsets.only(bottom: 27),
                        decoration: BoxDecoration(
                          border: Border(
                            bottom: BorderSide(
                              color: (selectedIndex == i)
                                  ? buttonColor
                                  : Colors.transparent,
                              width: 1,
                            ),
                          ),
                        ),
                        child: defaultText(
                          context,
                          widget.categoryList[i].name,
                          style: catNameStyle(),
                        ),
                      ),
                    ),
                    // AnimatedSwitcher(
                    //   duration: Duration(milliseconds: animatedTime),
                    //   transitionBuilder:
                    //       (Widget child, Animation<double> animation) {
                    //     return ScaleTransition(scale: animation, child: child);
                    //   },
                    //   child: (selectedIndex == i)
                    //       ? Container(
                    //           key: const Key('underline'),
                    //           margin: const EdgeInsets.only(top: 27),
                    //           width: 30,
                    //           height: 1,
                    //           color: buttonColor,
                    //         )
                    //       : const SizedBox(
                    //           key: Key('underline'),
                    //         ),
                    // )
                  ],
                ),
              ),
            );
          },
        );
      },
    );
  }
}
