// ignore_for_file: sized_box_for_whitespace

import 'package:flutter/material.dart';
import 'package:shimmer/shimmer.dart';

import '../../helper/helper.dart';

class ShimmerMenu extends StatelessWidget {
  const ShimmerMenu({
    Key? key,
    required this.widthScreen,
    required this.maxWidthScreen,
    required this.context,
  }) : super(key: key);

  final double widthScreen;
  final double maxWidthScreen;
  final BuildContext context;

  @override
  Widget build(BuildContext context) {
    return Shimmer.fromColors(
      baseColor: baseColorShimmer,
      highlightColor: highlightColorShimmer,
      child: Container(
        height: double.infinity,
        width: widthScreen,
        padding: EdgeInsets.symmetric(
          horizontal: widthScreen * 0.04,
        ),
        // color: Colors.red,
        child: Column(
          children: [
            AppBar(widthScreen: widthScreen),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.01,
            ),
            ListCategory(widthScreen: widthScreen),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.01,
            ),
            CategoryName(widthScreen: widthScreen),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.01,
            ),
            Container(
              height: MediaQuery.of(context).size.height * 0.81,
              child: ListView.builder(
                  itemCount: 4,
                  itemBuilder: (context, i) {
                    return Container(
                      height: MediaQuery.of(context).size.height * 0.18,
                      margin: EdgeInsets.only(
                          bottom: MediaQuery.of(context).size.height * 0.03),
                      child: Column(
                        children: [
                          MenuPriceAndImage(widthScreen: widthScreen),
                          SizedBox(
                            height: MediaQuery.of(context).size.height * 0.01,
                          ),
                          ButtonShimmer(widthScreen: widthScreen)
                        ],
                      ),
                    );
                  }),
            )
          ],
        ),
      ),
    );
  }
}

class ButtonShimmer extends StatelessWidget {
  const ButtonShimmer({
    Key? key,
    required this.widthScreen,
  }) : super(key: key);

  final double widthScreen;

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: Alignment.centerRight,
      child: Container(
        height: MediaQuery.of(context).size.height * 0.04,
        width: widthScreen * 0.27,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(roundedButton),
          color: Colors.red,
        ),
      ),
    );
  }
}

class MenuPriceAndImage extends StatelessWidget {
  const MenuPriceAndImage({
    Key? key,
    required this.widthScreen,
  }) : super(key: key);

  final double widthScreen;

  @override
  Widget build(BuildContext context) {
    return Container(
      height: MediaQuery.of(context).size.height * 0.12,
      // color: Colors.amber,
      child: Row(
        children: [
          // nama menu dan harga
          Container(
            width: widthScreen * 0.6,
            height: double.infinity,
            // color: Colors.red,
            child: GestureDetector(
              onTap: () {},
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  GestureDetector(
                      child: Container(
                    width: widthScreen * 0.55,
                    height: MediaQuery.of(context).size.height * 0.05,
                    color: Colors.red,
                  )),
                  SizedBox(height: MediaQuery.of(context).size.height * 0.01),
                  GestureDetector(
                      child: Container(
                    width: widthScreen * 0.2,
                    height: MediaQuery.of(context).size.height * 0.03,
                    color: Colors.red,
                  )),
                ],
              ),
            ),
          ),
          SizedBox(
            width: widthScreen * 0.05,
          ),
          // gambar menu
          GestureDetector(
            onTap: () {},
            child: Container(
              width: widthScreen * 0.27,
              height: double.infinity,
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(roundedImage),
                color: disabledColor.withOpacity(0.8),
              ),
            ),
          )
        ],
      ),
    );
  }
}

class CategoryName extends StatelessWidget {
  const CategoryName({
    Key? key,
    required this.widthScreen,
  }) : super(key: key);

  final double widthScreen;

  @override
  Widget build(BuildContext context) {
    return Align(
      alignment: Alignment.centerLeft,
      child: Container(
        width: widthScreen * 0.3,
        height: MediaQuery.of(context).size.height * 0.05,
        color: Colors.red,
      ),
    );
  }
}

class ListCategory extends StatelessWidget {
  const ListCategory({
    Key? key,
    required this.widthScreen,
  }) : super(key: key);

  final double widthScreen;

  @override
  Widget build(BuildContext context) {
    return Container(
      height: MediaQuery.of(context).size.height * 0.04,
      child: Row(
        children: [
          Container(
            // color: Colors.blue,
            width: widthScreen * 0.92,
            child: ListView.builder(
                scrollDirection: Axis.horizontal,
                itemCount: 5,
                itemBuilder: (context, i) {
                  return GestureDetector(
                    onTap: () {},
                    child: Container(
                      width: widthScreen * 0.174,
                      // padding: EdgeInsets.all(
                      //     MediaQuery.of(context).size.height * 0.01),
                      margin: EdgeInsets.only(
                        left: widthScreen * 0.01,
                      ),
                      height: double.infinity,
                      // color: Colors.blue,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(roundedButton),
                        color: Colors.red,
                      ),
                    ),
                  );
                }),
          )
        ],
      ),
    );
  }
}

class AppBar extends StatelessWidget {
  const AppBar({
    Key? key,
    required this.widthScreen,
  }) : super(key: key);

  final double widthScreen;

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.only(
        top: MediaQuery.of(context).size.height * 0.03,
      ),
      height: MediaQuery.of(context).size.height * 0.07,
      width: widthScreen * 0.92,
      child: Row(
        children: [
          Container(
            width: widthScreen * 0.7,
            height: double.infinity,
            color: Colors.red,
          ),
          SizedBox(
            width: widthScreen * 0.1,
          ),
          Container(
            width: widthScreen * 0.09,
            height: double.infinity,
            color: Colors.red,
          ),
        ],
      ),
    );
  }
}
