// ignore_for_file: sized_box_for_whitespace
import 'package:flutter/material.dart';
import 'package:shimmer/shimmer.dart';

import '../../helper/helper.dart';

class ShimmerMenuNew extends StatelessWidget {
  const ShimmerMenuNew({super.key});

  @override
  Widget build(BuildContext context) {
    return const CoreShimmer();
  }
}

class CoreShimmer extends StatelessWidget {
  const CoreShimmer({super.key});

  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    return Shimmer.fromColors(
      baseColor: baseColorShimmer,
      highlightColor: highlightColorShimmer,
      child: Container(
        width: widthScreen,
        height: MediaQuery.of(context).size.height,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Center(
              child: Container(
                margin: const EdgeInsets.only(
                    top: 16, left: paddingLeftRight, right: paddingLeftRight),
                width: 209,
                height: 80,
                color: Colors.black,
              ),
            ),
            Container(
              margin: const EdgeInsets.only(top: 22, left: 20, right: 20),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Container(
                    width: 66,
                    height: 20,
                    color: Colors.black,
                  ),
                  Container(
                    width: 66,
                    height: 20,
                    color: Colors.black,
                  ),
                ],
              ),
            ),
            listNamaCategory(widthScreen),
            Container(
              margin: const EdgeInsets.only(top: 8, left: 20, right: 20),
              height: 227,
              width: widthScreen,
              child: ListView.builder(
                  scrollDirection: Axis.horizontal,
                  itemCount: 5,
                  itemBuilder: (context, i) {
                    return Container(
                      margin: const EdgeInsets.only(right: 16),
                      height: 227,
                      width: 136,
                      color: Colors.black,
                    );
                  }),
            ),
            Container(
              margin: const EdgeInsets.only(top: 10, left: 20, right: 20),
              height: 20,
              width: 58,
              color: Colors.black,
            ),
            listNamaCategory(widthScreen),
            Expanded(
              child: ListView.builder(
                itemCount: 5,
                itemBuilder: (context, i) {
                  return Container(
                    margin: const EdgeInsets.only(top: 20, left: 20, right: 20),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Container(
                          height: 125,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Container(
                                width: 152,
                                height: 14,
                                color: Colors.black,
                              ),
                              Container(
                                width: 80,
                                height: 14,
                                color: Colors.black,
                              ),
                            ],
                          ),
                        ),
                        Container(
                          width: 125,
                          height: 125,
                          color: Colors.black,
                        )
                      ],
                    ),
                  );
                },
              ),
            )
          ],
        ),
        // child: Expanded(
        //   child: Container(
        //     padding: const EdgeInsets.only(
        //       top: 16,
        //     ),
        //     child: Row(
        //       children: [
        //         const Spacer(),
        //         Container(
        //           width: 209,
        //           height: 80,
        //           color: Colors.black,
        //         ),
        //         const Spacer(),
        //       ],
        //     ),
        //   ),
        // ),
      ),
    );
  }

  Container listNamaCategory(double widthScreen) {
    return Container(
      margin: const EdgeInsets.only(top: 22, left: 20, right: 20),
      height: 20,
      width: widthScreen,
      child: ListView.builder(
          scrollDirection: Axis.horizontal,
          itemCount: 5,
          itemBuilder: (context, i) {
            return Container(
              margin: const EdgeInsets.only(right: 25),
              height: 20,
              width: 100,
              color: Colors.black,
            );
          }),
    );
  }
}
