// ignore_for_file: sized_box_for_whitespace

import 'package:byod/bloc/order_variant_temporary.dart';
import 'package:byod/bloc/order_variant_value.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/models/order_details.dart';
import 'package:byod/models/order_variants.dart';
import 'package:byod/models/variants.dart';
import 'package:byod/ui/screen_responsive.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../helper/helper.dart';

// ignore: must_be_immutable
class Variant extends StatefulWidget {
  List<Variants> variants;
  String captioncategories;
  int type;
  int initPrice;
  String idCategory;
  OrderDetail orderDetail;
  Variant(
      {Key? key,
      required this.variants,
      required this.captioncategories,
      required this.type,
      required this.initPrice,
      required this.idCategory,
      required this.orderDetail})
      : super(key: key);

  @override
  State<Variant> createState() => _VariantState();
}

class _VariantState extends State<Variant> {
  String variantMenu = '';
  List<dynamic> variantRadio = [];
  List<String> optionalVariant = [];
  @override
  Widget build(BuildContext context) {
    double widthScreen = responsiveWidthScreen(context);
    double currentScreen = MediaQuery.of(context).size.width;

    double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    // if (variantRadio.isNotEmpty) {
    //   print(variantRadio[0]);
    // }

    return BlocBuilder<OrderVariantValueBloc, List<OrderVariant>>(
      builder: (context, orderVariants) {
        return ListView.builder(
            physics:
                const NeverScrollableScrollPhysics(), // to disable GridView's scrolling
            shrinkWrap: true,
            itemCount: widget.variants.length,
            itemBuilder: ((context, i) {
              var priceVariant = amountParseToInt(widget.variants[i].price);

              return BlocBuilder<OrderVariantTemporaryBloc, List<dynamic>>(
                builder: (context, listOrders) {
                  var listOrder = listOrders[0];
                  var itemId = listOrder[0];
                  var satuanPrice = listOrder[1];
                  var initialValue = listOrder[2];
                  return ScreenResponsive(
                    widget: variantList(
                      widthScreen,
                      i,
                      context,
                      priceVariant,
                      itemId,
                      satuanPrice,
                      initialValue,
                      orderVariants,
                      maxWidthScreen,
                    ),
                    widthScreen: currentScreen,
                    isCoreLayout: false,
                  );
                  // return variantList(widthScreen, i, context, priceVariant,
                  //     itemId, satuanPrice, initialValue, orderVariants);
                },
              );
            }));
      },
    );
  }

  Container variantList(
    double widthScreen,
    int i,
    BuildContext context,
    int priceVariant,
    itemId,
    satuanPrice,
    initialValue,
    List<OrderVariant> orderVariants,
    double maxWidthScreen,
  ) {
    return Container(
      width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
      child: Column(
        children: [
          Row(
            children: [
              Container(
                  width: widthScreen * 0.57,
                  // color: Colors.red,
                  // child: Text(
                  //   widget.variants[i].name,
                  //   maxLines: 2,
                  //   overflow: TextOverflow.ellipsis,
                  //   // style: const TextStyle(
                  //   //     fontWeight: FontWeight.w500, fontSize: 18),
                  //   style: textStyleNormalFont(context),
                  // ),
                  child: defaultText(
                    context,
                    widget.variants[i].name,
                    maxLines: 2,
                    overFlow: TextOverflow.ellipsis,
                    style: textStyleNormalFont(context),
                  )),
              Container(
                  width: widthScreen * 0.35,
                  // color: Colors.blue,
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Container(
                          margin: EdgeInsets.only(left: widthScreen * 0.05),
                          // child: Text(
                          //   (priceVariant > 0)
                          //       ? formatNumber().format(priceVariant)
                          //       : "Free",
                          //   // style: const TextStyle(
                          //   //     fontWeight: FontWeight.w600,
                          //   //     fontSize: 15),
                          //   style: textStyleNormalFont(
                          //     context,
                          //     isBold: true,
                          //   ),
                          // )
                          child: defaultText(
                            context,
                            (priceVariant > 0)
                                ? formatNumber().format(priceVariant)
                                : "Free",
                            style: textStyleNormalFont(
                              context,
                              isBold: true,
                            ),
                          )),
                      (widget.type == typeMandatory)
                          ? radioButton(
                              i,
                              itemId,
                              satuanPrice,
                              initialValue,
                              variantRadio,
                              priceVariant,
                              widget.idCategory,
                              orderVariants)
                          : (widget.type == typeOptional)
                              ? checkBoxButton(
                                  i,
                                  itemId,
                                  satuanPrice,
                                  initialValue,
                                  variantRadio,
                                  priceVariant,
                                  widget.idCategory,
                                  orderVariants)
                              : const SizedBox()
                    ],
                  )),
            ],
          )
        ],
      ),
    );
  }

  Checkbox checkBoxButton(
      int i,
      String itemId,
      int satuanHarga,
      int initialValue,
      List<dynamic> variantRadio,
      int priceVariant,
      String idCategory,
      List<OrderVariant> orderVariants) {
    return Checkbox(
        activeColor: buttonColor,
        value: (optionalVariant.contains(widget.variants[i].id) == true)
            ? true
            : false,
        onChanged: (value) {
          (value == true)
              ? optionalVariant.add(widget.variants[i].id)
              : optionalVariant.remove(widget.variants[i].id);
          context.read<OrderVariantValueBloc>().setOrderVariant(
              idCategory,
              widget.variants[i].id,
              widget.variants[i].name,
              priceVariant,
              typeOptional,
              orderVariants,
              widget.captioncategories,
              forChecBox: value);
          setState(() {});
        });
  }

  Radio<String> radioButton(
      int i,
      String itemId,
      int satuanHarga,
      int initialValue,
      List<dynamic> variantRadio,
      int priceVariant,
      String idCategory,
      List<OrderVariant> orderVariants) {
    return Radio(
        value: widget.variants[i].id,
        groupValue: variantMenu,
        hoverColor: buttonColor,
        activeColor: buttonColor,
        onChanged: (newValue) {
          // buat list untuk radio button
          variantMenu = newValue.toString();

          context.read<OrderVariantValueBloc>().setOrderVariant(
                idCategory,
                variantMenu.toString(),
                widget.variants[i].name,
                priceVariant,
                typeMandatory,
                orderVariants,
                widget.captioncategories,
              );
          setState(() {});
        });
  }
}
