// ignore_for_file: must_be_immutable, avoid_unnecessary_containers

import 'package:byod/helper/helper.dart';
import 'package:byod/helper/prefs.dart';
import 'package:byod/helper/widget/style.dart';
import 'package:byod/main.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:geolocator/geolocator.dart';

import '../helper/widget/button_modal.dart';

class NoRoute extends StatelessWidget {
  String identification;
  NoRoute({Key? key, required this.identification}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    LocationPermission? permission;
    Geolocator.checkPermission().then((value) {
      permission = value;
    });
    return SafeArea(
      child: Scaffold(
        backgroundColor: backgroundColor,
        body: Center(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              // const Icon(
              //   Icons.highlight_remove_outlined,
              //   size: 80,
              //   color: Colors.red,
              // ),
              fontAwesome(
                context,
                timesCircleIcon,
                timesCircleIconSize,
                color: dangerColor,
                isBold: false,
              ),
              SizedBox(
                height: MediaQuery.of(context).size.height * 0.05,
              ),
              (identification == titleError)
                  ? defaultText(
                      context,
                      "Scan QR Atau Kunjungi Alamat Outlet (Error: title)",
                      textAlign: TextAlign.center,
                      style: textStyleNormalFont(context),
                    )
                  : (identification == configError)
                      ? defaultText(
                          context,
                          "Scan QR Atau Kunjungi Alamat Outlet (Error: config)",
                          textAlign: TextAlign.center,
                          style: textStyleNormalFont(context),
                        )
                      : (identification == gpsNotActive)
                          ? defaultText(
                              context,
                              "Delivery/Pickup order memerlukan akses GPS",
                              textAlign: TextAlign.center,
                              style: textStyleNormalFont(context),
                            )
                          : (identification == locationPermissinDenied)
                              ? defaultText(
                                  context,
                                  "Delivery/Pickup order memerlukan akses lokasi anda, Silahkan ubah pengaturan lokasi browser anda",
                                  textAlign: TextAlign.center,
                                  style: textStyleNormalFont(context),
                                )
                              : defaultText(
                                  context,
                                  "Scan QR Atau Kunjungi Alamat Outlet",
                                  textAlign: TextAlign.center,
                                  style: textStyleNormalFont(context),
                                ),
              (identification == locationPermissinDenied)
                  ? GestureDetector(
                      onTap: () {
                        Geolocator.requestPermission().then((value) {
                          if (value != LocationPermission.denied &&
                              value != LocationPermission.deniedForever) {
                            Navigator.pushReplacement(
                              context,
                              MaterialPageRoute(
                                builder: (_) => MyApp(
                                  title: getTitleWeb(),
                                ),
                              ),
                            );
                          } else {
                            EasyLoading.showToast(
                                'Silahkan aktifkan lokasi browser anda');
                          }
                        });
                      },
                      child: Container(
                        margin: const EdgeInsets.only(top: 15),
                        width: 200,
                        child: ButtonComponent(
                          buttonColor: buttonColor,
                          teksButton: 'Lanjutkan',
                        ),
                      ),
                    )
                  : const SizedBox()
            ],
          ),
        ),
      ),
    );
  }
}
