// ignore_for_file: must_be_immutable, sized_box_for_whitespace

import 'dart:convert';

import 'package:byod/bloc/member_info.dart';
import 'package:byod/helper/helper.dart';
import 'package:byod/helper/prefs.dart';
import 'package:byod/ui/no_route.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:geolocator/geolocator.dart';

import '../bloc/branch_exist.dart';
import '../bloc/filter_menu.dart';
import '../main.dart';
import 'package:flutter/services.dart' as bundle_root;
import 'home/new_home2.dart';
import 'home/shimmer_menu_new.dart';
import 'screen_responsive.dart';

class Splash extends StatefulWidget {
  final List<String> pathSegmentString;
  final BuildContext context;
  const Splash({
    Key? key,
    required this.pathSegmentString,
    required this.context,
  }) : super(key: key);

  @override
  State<Splash> createState() => _SplashState();
}

class _SplashState extends State<Splash> {
  Future<String> loadBaseUrl() async {
    String data;
    try {
      String datas = await bundle_root.rootBundle.loadString('config.json');
      data = jsonDecode(datas)['base_url'].toString();
      return data;
    } catch (e) {
      navigatorKey.currentState?.push(MaterialPageRoute(
          builder: (context) => NoRoute(
                identification: 'configError',
              )));
      return '';
    }
  }

  @override
  void initState() {
    loadBaseUrl().then((baseUrl) {
      setBaseUrl(baseUrl);
      if (widget.pathSegmentString.isEmpty) {
        Geolocator.requestPermission().then((permission) {
          if (permission != LocationPermission.denied &&
              permission != LocationPermission.deniedForever) {
            setPaymentMode(closebill);
            setIsDeliveryPickup(true);
            setUrlLookUp(Uri.base.toString());
            Geolocator.getCurrentPosition().then((position) {
              setLatitude(position.latitude.toString());
              setLongitude(position.longitude.toString());
              setUrlType(typeUrlTiga);
              List<String> listTypeUrl = getListTypeUrl();

              int indexTypeUrlTiga = listTypeUrl.indexWhere(
                  (list) => jsonDecode(list)['url_type'] == typeUrlTiga);
              if (indexTypeUrlTiga == -1) {
                Map saveTypeUrlAndOrderId = {
                  "url_type": typeUrlTiga,
                  "order_id": '',
                };
                listTypeUrl.add(
                  jsonEncode(saveTypeUrlAndOrderId),
                );
                setListTypeUrl(listTypeUrl);
              }

              widget.context.read<BranchExist>().branchExist(
                    getBranchPref(),
                    getBrand(),
                    getRole(),
                    getCashierName(),
                    '',
                    widget.context,
                    getBrancList: true,
                  );
              Future.delayed(const Duration(milliseconds: 2000), () async {
                // if (getStatusOrderCreated()) {
                context.read<FilterMenuBloc>().catAndMenu(
                      getBranchPref(),
                      getBrand(),
                      getRole(),
                      getCashierName(),
                      getOrderId(),
                    );
                Navigator.pushReplacement(
                  widget.context,
                  MaterialPageRoute(
                    builder: (_) => const NewHome2(),
                  ),
                );
                // } else {
                //   Navigator.pushReplacement(
                //     widget.context,
                //     MaterialPageRoute(
                //       builder: (_) => const SelectBranch(),
                //     ),
                //   );
                // }
              });
            });
          } else {
            Navigator.pushReplacement(
              widget.context,
              MaterialPageRoute(
                builder: (_) => NoRoute(
                  identification: locationPermissinDenied,
                ),
              ),
            );
          }
        });
      } else if (widget.pathSegmentString.length == 1) {
        setPaymentMode(closebill);
        setIsDeliveryPickup(false);
        setUrlLookUp('');
        Navigator.pushReplacement(
          widget.context,
          MaterialPageRoute(
            builder: (_) => NoRoute(
              identification: emptyUri,
            ),
          ),
        );
      } else if (widget.pathSegmentString.length == 2) {
        setPaymentMode(openBill);
        setIsDeliveryPickup(false);
        setUrlLookUp('');
        if (widget.pathSegmentString[0] == 'o') {
          if (widget.pathSegmentString[1] != '') {
            setOrderId(widget.pathSegmentString[1]);
            setUrlType(typeUrlSatu);
            List<String> listTypeUrl = getListTypeUrl();

            int indexTypeUrlSatu = listTypeUrl.indexWhere(
                (list) => jsonDecode(list)['url_type'] == typeUrlSatu);
            if (indexTypeUrlSatu == 1) {
              listTypeUrl.removeWhere(
                  (element) => jsonDecode(element)['url_type'] == typeUrlSatu);
            }
            Map saveTypeUrlAndOrderId = {
              "url_type": typeUrlSatu,
              "order_id": widget.pathSegmentString[1],
            };
            listTypeUrl.add(
              jsonEncode(saveTypeUrlAndOrderId),
            );
            setListTypeUrl(listTypeUrl);
            widget.context.read<BranchExist>().branchExist(
                  getBranchPref(),
                  getBrand(),
                  getRole(),
                  getCashierName(),
                  getOrderId(), // ini orderId dari path URL
                  widget.context,
                  getMenu: true,
                );
            goToMenu(widget.context);
          } else {
            Navigator.pushReplacement(
              widget.context,
              MaterialPageRoute(
                builder: (_) => NoRoute(
                  identification: emptyUri,
                ),
              ),
            );
          }
        } else {
          Navigator.pushReplacement(
            widget.context,
            MaterialPageRoute(
              builder: (_) => NoRoute(
                identification: emptyUri,
              ),
            ),
          );
        }
      } else if (widget.pathSegmentString.length == 3) {
        setPaymentMode(closebill);
        setIsDeliveryPickup(false);
        setUrlLookUp('');
        setBranch(widget.pathSegmentString[1]);
        setBrand(widget.pathSegmentString[0]);
        setTableNumber(widget.pathSegmentString[2]);

        setUrlType(typeUrlDua);
        List<String> listTypeUrl = getListTypeUrl();

        int indextypeUrlDua = listTypeUrl
            .indexWhere((list) => jsonDecode(list)['url_type'] == typeUrlDua);
        if (indextypeUrlDua == -1) {
          Map saveTypeUrlAndOrderId = {
            "url_type": typeUrlDua,
            "order_id": '',
          };
          listTypeUrl.add(
            jsonEncode(saveTypeUrlAndOrderId),
          );
          setListTypeUrl(listTypeUrl);
        }
        goToMenu(widget.context);
        widget.context.read<BranchExist>().branchExist(
              getBranchPref(),
              getBrand(),
              getRole(),
              getCashierName(),
              getOrderId(), // ini orderId dari path URL
              widget.context,
              getMenu: true,
            );
        goToMenu(widget.context);
      } else if (widget.pathSegmentString.length == 4) {
        setPaymentMode(closebill);
        setIsDeliveryPickup(false);
        setUrlLookUp('');
        setBranch(widget.pathSegmentString[1]);
        setBrand(widget.pathSegmentString[0]);
        setTableNumber(widget.pathSegmentString[2]);
        setToken(widget.pathSegmentString[3]);
        context.read<MemberInfoBloc>().getMemberInfo(getToken());

        setUrlType(typeUrlDua);
        List<String> listTypeUrl = getListTypeUrl();

        int indextypeUrlDua = listTypeUrl
            .indexWhere((list) => jsonDecode(list)['url_type'] == typeUrlDua);
        if (indextypeUrlDua == -1) {
          Map saveTypeUrlAndOrderId = {
            "url_type": typeUrlDua,
            "order_id": '',
          };
          listTypeUrl.add(
            jsonEncode(saveTypeUrlAndOrderId),
          );
          setListTypeUrl(listTypeUrl);
        }

        widget.context.read<BranchExist>().branchExist(
              getBranchPref(),
              getBrand(),
              getRole(),
              getCashierName(),
              getOrderId(), // ini orderId dari path URL
              widget.context,
              getMenu: true,
            );
        goToMenu(widget.context);
      }

      // context.read<CategoryMenu>().catAndMenu(widget.branch, widget.brand,
      //     widget.role, widget.cashierName, widget.token);

      // context.read<FilterMenuBloc>().catAndMenu(widget.branch, widget.brand,
      //     widget.role, widget.cashierName, widget.token);

      // if (widget.token != '') {
      //   context.read<MemberInfoBloc>().getMemberInfo(widget.token);
      // }
      // Future.delayed(const Duration(milliseconds: 1000), () async {
      //   // setToken(widget.token);
      //   // setBranch(widget.branch);
      //   // setBrand(widget.brand);
      //   // setTableNumber(widget.tn);
      //   // setRole(widget.role);
      //   // setCashierName(widget.cashierName);
      //   // ignore: use_build_context_synchronously

      //   // if (widget.toBill == goBill) {
      //   //   // ignore: use_build_context_synchronously
      //   //   Navigator.pushReplacement(
      //   //       context, MaterialPageRoute(builder: (_) => const ViewBillNew()));
      //   // } else {
      //   // ignore: use_build_context_synchronously
      //   // Navigator.pushReplacement(
      //   //     context, MaterialPageRoute(builder: (_) => const Home()));
      //   // ignore: use_build_context_synchronously
      //   Navigator.pushReplacement(
      //     context,
      //     MaterialPageRoute(
      //       builder: (_) => const NewHome2(),
      //     ),
      //   );
      //   // }
      // });
    });

    super.initState();
  }

  void goToMenu(contexts) {
    Future.delayed(const Duration(milliseconds: 2000), () async {
      Navigator.pushReplacement(
        contexts,
        MaterialPageRoute(
          builder: (_) => const NewHome2(),
        ),
      );
    });
  }

  @override
  Widget build(BuildContext context) {
    // double widthScreen = responsiveWidthScreen(context);
    // double maxWidthScreen = getMaxWidthScreen(context, useResponsive);
    return SafeArea(
      child: Scaffold(
        backgroundColor: backgroundColor,
        // body: Center(
        //   child: Column(
        //     mainAxisAlignment: MainAxisAlignment.center,
        //     children: [
        //       // Text(
        //       //   "Membuka Menu....",
        //       //   // style: TextStyle(
        //       //   //   fontSize: MediaQuery.of(context).size.height * 0.03,
        //       //   //   fontWeight: FontWeight.w500,
        //       //   //   color: buttonColor,
        //       //   //   decoration: TextDecoration.none,
        //       //   // ),
        //       //   style: textStyleMenuList(
        //       //     context,
        //       //     textColor: buttonColor,
        //       //   ),
        //       // ),
        //       defaultText(
        //         context,
        //         "Membuka Menu....",
        //         style: textStyleMenuList(context, textColor: buttonColor),
        //       ),
        //       LoadingBumpingLine.circle(
        //         size: MediaQuery.of(context).size.height * 0.1,
        //         backgroundColor: buttonColor,
        //       )
        //       // ShimmerSplash(
        //       //   widthScreen: widthScreen,
        //       //   maxWidthScreen: maxWidthScreen,
        //       // )
        //     ],
        //   ),
        // ),
        body: ScreenResponsive(
          widget: const ShimmerMenuNew(),
          widthScreen: MediaQuery.of(context).size.width,
          isCoreLayout: true,
        ),
      ),
    );
  }
}

// class ShimmerSplash extends StatelessWidget {
//   double widthScreen;
//   double maxWidthScreen;
//   ShimmerSplash({
//     Key? key,
//     required this.maxWidthScreen,
//     required this.widthScreen,
//   }) : super(key: key);

//   @override
//   Widget build(BuildContext context) {
//     return Shimmer.fromColors(
//       baseColor: disabledColor,
//       highlightColor: buttonColor,
//       child: SingleChildScrollView(
//         child: Column(
//           children: [
//             Stack(
//               children: [
//                 Column(
//                   children: [
//                     customAppbar(
//                       context,
//                       widthScreen,
//                       maxWidthScreen,
//                     ),
//                     Container(
//                         height: MediaQuery.of(context).size.height * 0.865,
//                         width: widthScreen,
//                         // color: Colors.red,
//                         child: ListView(
//                           children: [
//                             listViewCategory(
//                               widthScreen,
//                             ),
//                           ],
//                         )),
//                   ],
//                 ),
//               ],
//             ),
//           ],
//         ),
//       ),
//     );
//   }

//   ListView listViewCategory(double widthScreen) {
//     return ListView.builder(
//       physics:
//           const NeverScrollableScrollPhysics(), // to disable GridView's scrolling
//       shrinkWrap: true,
//       itemCount: 3,
//       itemBuilder: (context, i) {
//         return Column(
//           children: [
//             Align(
//               alignment: Alignment.centerLeft,
//               child: Container(
//                 height: MediaQuery.of(context).size.height * 0.06,
//                 width: widthScreen * 0.2,
//                 decoration: BoxDecoration(
//                   borderRadius: BorderRadius.circular(roundedButton),
//                   // color: Colors.red,
//                 ),
//                 // color: Colors.green,
//                 // child: Align(
//                 //   alignment: Alignment.centerLeft,
//                 //   child: textCategory(
//                 //     context,
//                 //     categoryMenu[i].name,
//                 //   ),
//                 //   // child: Text(
//                 //   //   categoryMenu[i].name,
//                 //   //   // style: TextStyle(
//                 //   //   //     fontSize:
//                 //   //   //         MediaQuery.of(context).size.height * categoryFont,
//                 //   //   //     fontWeight: FontWeight.w600),
//                 //   //   style: textStyleCategoryMenu(context),
//                 //   // ),
//                 // ),
//               ),
//             ),
//             SizedBox(
//               height: MediaQuery.of(context).size.height * 0.015,
//             ),
//             listViewMenu(widthScreen)
//           ],
//         );
//       },
//     );
//   }

//   ListView listViewMenu(double widthScreen) {
//     return ListView.builder(
//         // controller: _scrollController,
//         physics:
//             const NeverScrollableScrollPhysics(), // to disable GridView's scrolling
//         shrinkWrap: true,
//         itemCount: 5, // harus sama dengan item count dibawah, tujuan layouting
//         itemBuilder: (context, d) {
//           return MenuView(
//             isHaveItem: false,
//             id: '',
//             itemKe: 0,
//             itemCount:
//                 5, // harus sama dengan item count diatas, tujuan layouting
//             namaMenu: '',
//             hargaCoret: 0,
//             hargaFix: 0,
//             imageUrl: '',
//             isHaveVariant: false,
//             variantCat: const [],
//             isSell: false,
//             widthScreenParent: widthScreen,
//             isShimmer: true,
//           );
//         });
//   }

//   Shimmer customAppbar(
//     BuildContext context,
//     double widthScreen,
//     double maxWidthScreen,
//   ) {
//     FocusScopeNode currentFocus = FocusScope.of(context);
//     return Shimmer.fromColors(
//       baseColor: Colors.grey,
//       highlightColor: buttonColor,
//       child: Container(
//         height: MediaQuery.of(context).size.height * 0.12,
//         // color: Colors.amber,
//         width: (widthScreen > maxWidthScreen) ? maxWidthScreen : widthScreen,
//         child: Column(
//           children: [
//             Container(
//               height: MediaQuery.of(context).size.height * 0.07,
//               child: Row(
//                 mainAxisAlignment: MainAxisAlignment.spaceEvenly,
//                 children: [
//                   // Container(
//                   //   // color: Colors.white,
//                   //   height: double.infinity,
//                   //   width: MediaQuery.of(context).size.width * 0.2,
//                   //   child: const Icon(Icons.arrow_back_ios_new_rounded),
//                   // ),
//                   Container(
//                     color: Colors.red,
//                     height: double.infinity,
//                     width: widthScreen * 0.58,
//                     // child: Align(
//                     //   alignment: Alignment.centerLeft,
//                     //   child: defaultText(context, barName,
//                     //       overFlow: TextOverflow.ellipsis,
//                     //       style: textStyleMenuList(context)),
//                     // ),
//                   ),
//                   GestureDetector(
//                     onTap: () {
//                       // setState(() {
//                       //   isSearch = !isSearch;
//                       //   if (isSearch == false) {
//                       //     currentFocus.unfocus();
//                       //     searchController.text = '';
//                       //   }
//                       // });
//                     },
//                     child: Container(
//                       color: Colors.blue,
//                       height: double.infinity,
//                       width: widthScreen * 0.1,
//                     ),
//                   ),
//                   GestureDetector(
//                     onTap: () {
//                       // setState(() {
//                       //   isSearch = !isSearch;
//                       //   if (isSearch == false) {
//                       //     currentFocus.unfocus();
//                       //     searchController.text = '';
//                       //   }
//                       // });
//                     },
//                     child: Container(
//                       color: Colors.blue,
//                       height: double.infinity,
//                       width: widthScreen * 0.17,
//                     ),
//                   )
//                 ],
//               ),
//             ),
//             Container(
//               height: MediaQuery.of(context).size.height * 0.04,
//               // color: Colors.red,
//               child: Row(
//                 children: [
//                   Container(
//                     // color: Colors.blue,
//                     width: widthScreen * 0.915,
//                     child: ListView.builder(
//                         scrollDirection: Axis.horizontal,
//                         itemCount: 4,
//                         itemBuilder: (context, i) {
//                           return GestureDetector(
//                             onTap: () {},
//                             child: Container(
//                               // width: MediaQuery.of(context).size.width * 0.25,
//                               width: widthScreen * 0.3,
//                               padding: EdgeInsets.all(
//                                   MediaQuery.of(context).size.height * 0.01),
//                               margin: EdgeInsets.only(
//                                   left: (i == 0) ? 0 : widthScreen * 0.007,
//                                   right:
//                                       (i == 4 - 1) ? 0 : widthScreen * 0.007),
//                               height: double.infinity,
//                               // color: Colors.blue,
//                               decoration: BoxDecoration(
//                                   borderRadius:
//                                       BorderRadius.circular(roundedButton),
//                                   color: Colors.black
//                                   // color:
//                                   //     (selectedCategory[1] == categoryList[i].name)
//                                   //         ? selectedColor
//                                   //         : buttonColor,
//                                   ),
//                               // child: Center(
//                               //     // child: Text(categoryList[i].name,
//                               //     //     // style: TextStyle(
//                               //     //     //     fontSize:
//                               //     //     //         MediaQuery.of(context).size.height *
//                               //     //     //             categoryListFont,
//                               //     //     //     color: (selectedCategory[1] ==
//                               //     //     //             categoryList[i].name)
//                               //     //     //         ? const Color.fromARGB(
//                               //     //     //             255, 225, 250, 5)
//                               //     //     //         : textInButton,
//                               //     //     //     fontWeight: FontWeight.w600),
//                               //     //     style: textStyleSelectedCategory(
//                               //     //       context,
//                               //     //     )
//                               //     //     )
//                               //     child:
//                               //         defaultText(context, categoryList[i].name,
//                               //             style: textStyleSelectedCategory(
//                               //               context,
//                               //             ))),
//                             ),
//                           );
//                         }),
//                   )
//                 ],
//               ),
//               // child: ListView.builder(itemBuilder: ),
//             )
//           ],
//         ),
//       ),
//     );
//   }
// }
