// ignore_for_file: sized_box_for_whitespace

import 'package:byod/helper/prefs.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/branch_exist.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../home/new_home2.dart';

class CustomAppBar extends StatelessWidget {
  const CustomAppBar({
    Key? key,
    required this.isHistory,
  }) : super(key: key);

  final bool isHistory;

  @override
  Widget build(BuildContext context) {
    String branchCode = getBranchPref();
    String brandCode = getBrand();
    String role = getRole();
    String cashierName = getCashierName();
    String orderId = getOrderId();
    return Container(
      padding: const EdgeInsets.only(
        top: 15,
        bottom: 19,
        left: paddingLeftRight,
        right: paddingLeftRight,
      ),
      // padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
      color: backgroundWhite,
      child: Row(
        // mainAxisAlignment: MainAxisAlignment.start,
        children: [
          GestureDetector(
            onTap: () {
              if (!isHistory) {
                Navigator.pushReplacement(context,
                    MaterialPageRoute(builder: (_) => const NewHome2()));
                context.read<BranchExist>().branchExist(
                      branchCode,
                      brandCode,
                      role,
                      cashierName,
                      orderId,
                      context,
                    );
              } else {
                Navigator.pop(context);
              }
            },
            child: Container(
              width: 24,
              height: 24,
              child: Center(
                child: fontAwesomeNew(
                  arrowBack,
                  arrowBackSize,
                ),
              ),
            ),
          ),
          const SizedBox(
            width: 16,
          ),
          Center(
            child: defaultText(
              context,
              (!isHistory) ? 'Check-Out' : 'Riwayat Pesanan',
              maxLines: 1,
              overFlow: TextOverflow.ellipsis,
              style: appBarNameViewBill(),
            ),
          ),
        ],
      ),
    );
  }
}
