// ignore_for_file: sized_box_for_whitespace

import 'package:flutter/material.dart';
import '../../models/bill.dart';
import '../../models/bill_detail.dart';
import 'order_view_bill_new.dart';

class ListOrder extends StatelessWidget {
  const ListOrder({
    Key? key,
    required this.bill,
    required this.isHistory,
    required this.tableStatus,
  }) : super(key: key);

  final List<Bill> bill;
  final bool isHistory;
  final int tableStatus;

  @override
  Widget build(BuildContext context) {
    return ListView.builder(
        physics: const NeverScrollableScrollPhysics(), // to disable  scrolling
        shrinkWrap: true,
        itemCount: bill.length,
        itemBuilder: (context, i) {
          return ListView.builder(
            physics:
                const NeverScrollableScrollPhysics(), // to disable  scrolling
            shrinkWrap: true,
            itemCount: bill[i].billDetail.length,
            itemBuilder: (ctx, d) {
              return OrderViewBillNew(
                billDetail: bill[i].billDetail[d],
                lastItem:
                    (i + 1 == bill.length && d + 1 == bill[i].billDetail.length)
                        ? true
                        : false,
                isHistory: isHistory,
                tableStatus: tableStatus,
              );
            },
          );
        });
  }
}
