import 'package:byod/helper/prefs.dart';
import 'package:flutter/material.dart';

import '../../helper/helper.dart';
import '../../helper/widget/style.dart';
import '../../models/bill.dart';

class RincianPembayaran extends StatelessWidget {
  const RincianPembayaran({
    Key? key,
    required this.dataBill,
    required this.totalDiscount,
    required this.outStandingAll,
  }) : super(key: key);

  final List<Bill> dataBill;
  final int totalDiscount;
  final int outStandingAll;

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(
        horizontal: paddingLeftRight,
        vertical: 16,
      ),
      // height: 209,
      color: backgroundWhite,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisSize: MainAxisSize.min,
        children: [
          defaultText(
            context,
            'Rincian Pembayaran',
            style: rincianPembayaran(font: 14),
          ),
          const SizedBox(
            height: 20,
          ),
          const Divider(
            thickness: 0.3,
            color: dividerGrey,
          ),
          Row(
            children: [
              defaultText(
                context,
                'Subtotal',
                style: rincianPembayaran(
                  font: 12,
                  color: textGreyBill,
                ),
              ),
              const Spacer(),
              defaultText(
                context,
                'Rp ${formatNumber().format(amountParseToInt(dataBill[0].subTotalSeluruhOrderan))}',
                style: rincianPembayaran(
                  font: 12,
                  color: textGreyBill,
                ),
              ),
            ],
          ),
          const SizedBox(
            height: 8,
          ),
          Row(
            children: [
              defaultText(
                context,
                'Discount',
                style: rincianPembayaran(
                  font: 12,
                  color: textGreyBill,
                ),
              ),
              const Spacer(),
              defaultText(
                context,
                (totalDiscount == 0)
                    ? '-'
                    : 'Rp ${formatNumber().format(totalDiscount)}',
                style: rincianPembayaran(
                  font: 12,
                  color: textGreyBill,
                ),
              ),
            ],
          ),
          (getIsDeliveryPickup())
              ? const SizedBox(
                  height: 8,
                )
              : const SizedBox(),
          (getIsDeliveryPickup())
              ? Row(
                  children: [
                    defaultText(
                      context,
                      'Packaging Fee',
                      style: rincianPembayaran(
                        font: 12,
                        color: textGreyBill,
                      ),
                    ),
                    const Spacer(),
                    defaultText(
                      context,
                      (amountParseToInt(dataBill[0].packagingFee) == 0)
                          ? '-'
                          : 'Rp ${formatNumber().format(amountParseToInt(dataBill[0].packagingFee))}',
                      style: rincianPembayaran(
                        font: 12,
                        color: textGreyBill,
                      ),
                    ),
                  ],
                )
              : const SizedBox(),
          (getIsDeliveryPickup())
              ? const SizedBox(
                  height: 8,
                )
              : const SizedBox(),
          (getIsDeliveryPickup())
              ? Row(
                  children: [
                    defaultText(
                      context,
                      'Platform Fee',
                      style: rincianPembayaran(
                        font: 12,
                        color: textGreyBill,
                      ),
                    ),
                    const Spacer(),
                    defaultText(
                      context,
                      (amountParseToInt(dataBill[0].platformFee) == 0)
                          ? '-'
                          : 'Rp ${formatNumber().format(amountParseToInt(dataBill[0].platformFee))}',
                      style: rincianPembayaran(
                        font: 12,
                        color: textGreyBill,
                      ),
                    ),
                  ],
                )
              : const SizedBox(),
          const SizedBox(
            height: 8,
          ),
          Row(
            children: [
              defaultText(
                context,
                'Total',
                style: rincianPembayaran(
                  font: 12,
                  color: textGreyBill,
                ),
              ),
              const Spacer(),
              defaultText(
                context,
                'Rp ${formatNumber().format(amountParseToInt(dataBill[0].totalSeluruhOrderan))}',
                style: rincianPembayaran(
                  font: 12,
                  color: textGreyBill,
                ),
              ),
            ],
          ),
          const SizedBox(
            height: 8,
          ),
          const Divider(
            thickness: 0.3,
            color: dividerGrey,
          ),
          const SizedBox(
            height: 8,
          ),
          Row(
            children: [
              defaultText(
                context,
                'Unpaid',
                style: rincianPembayaran(
                  font: 12,
                ),
              ),
              const Spacer(),
              defaultText(
                context,
                (outStandingAll == 0)
                    ? '-'
                    : 'Rp ${formatNumber().format(outStandingAll)}',
                style: rincianPembayaran(
                  font: 12,
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
