// ignore_for_file: sized_box_for_whitespace

import 'package:byod/ui/home/new_home2.dart';
import 'package:byod/ui/viewbill/view_bill_new.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../bloc/address_user_bloc.dart';
import '../../helper/helper.dart';
import '../../helper/widget/style.dart';

class CustomAppBar extends StatelessWidget {
  const CustomAppBar({Key? key, required this.titleAppBar}) : super(key: key);

  final String titleAppBar;

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(
        top: 15,
        bottom: 19,
        left: paddingLeftRight,
        right: paddingLeftRight,
      ),
      // padding: const EdgeInsets.symmetric(horizontal: paddingLeftRight),
      color: backgroundWhite,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Row(
            children: [
              GestureDetector(
                onTap: () {
                  Navigator.pushReplacement(
                    context,
                    MaterialPageRoute(
                      builder: (_) => const ViewBillNew(),
                    ),
                  );
                },
                child: Container(
                  width: 24,
                  height: 24,
                  child: Center(
                    child: fontAwesomeNew(
                      arrowBack,
                      arrowBackSize,
                    ),
                  ),
                ),
              ),
              const SizedBox(
                width: 16,
              ),
              Center(
                child: defaultText(
                  context,
                  titleAppBar,
                  maxLines: 1,
                  overFlow: TextOverflow.ellipsis,
                  style: appBarNameViewBill(),
                ),
              ),
            ],
          ),
          GestureDetector(
            onTap: () {
              Navigator.pushReplacement(
                context,
                MaterialPageRoute(
                  builder: (_) => const ViewBillNew(),
                ),
              );
            },
            child: Row(
              children: [
                defaultText(
                  context,
                  'Simpan',
                  style: appBarNameViewBill(),
                ),
                const SizedBox(
                  width: 5,
                ),
                fontAwesomeNew(
                  saveIcon,
                  saveIconSize,
                ),
              ],
            ),
          ),
        ],
      ),
    );
  }
}
