import 'package:excelso_attendance/resource/colors.dart';
import 'package:excelso_attendance/resource/size.dart';
import 'package:excelso_attendance/resource/style.dart';
import 'package:flutter/material.dart';

class InputTextField extends StatelessWidget {
  const InputTextField({
    Key? key,
    required this.controller,
    required this.labelText,
    this.secure = false,
    this.enabled = true,
    this.showCounter = false,
    this.inputType = TextInputType.text,
    this.maxLines = 1,
    this.maxLength = 100,
    this.marginActive = false,
    this.isError = false,
    this.hintText = '',
    this.labelColor,
    this.isSuffixActive = false,
    this.suffixIcon,
    this.onSuffixPress,
    this.onChanged,
    this.borderSideActive = false,
    this.marginTop,
  }) : super(key: key);

  final TextEditingController controller;
  final String labelText;
  final bool secure;
  final bool enabled;
  final bool showCounter;
  final TextInputType inputType;
  final int maxLines;
  final int? maxLength;
  final bool marginActive;
  final bool isError;
  final String hintText;
  final Color? labelColor;
  final bool isSuffixActive;
  final IconData? suffixIcon;
  final void Function()? onSuffixPress;
  final void Function(String val)? onChanged;
  final bool borderSideActive;
  final double? marginTop;

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.symmetric(
        horizontal: (marginActive) ? AppPadding.p20 : 0,
      ),
      margin: EdgeInsets.only(
        top: (marginTop != null) ? marginTop! : 0,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            margin: EdgeInsets.only(
              bottom: AppMargin.m12,
            ),
            child: Text(
              labelText,
              style: getSemiBoldStyle(
                color: (labelColor == null) ? Colors.black : labelColor!,
                fontSize: 16,
              ),
            ),
          ),
          TextField(
            maxLength: maxLength,
            maxLines: maxLines,
            enabled: enabled,
            onChanged: onChanged,
            obscureText: secure,
            keyboardType: inputType,
            textInputAction: TextInputAction.done,
            controller: controller,
            decoration: InputDecoration(
              hintText: hintText,
              hintStyle: getRegularStyle(
                color: Colors.grey,
              ),
              counterText: (showCounter) ? null : "",
              enabledBorder: (borderSideActive)
                  ? OutlineInputBorder(
                      borderSide: BorderSide(
                          width: 0.4,
                          color: (isError) ? Colors.red : ColorManager.grey),
                      borderRadius: BorderRadius.circular(5),
                    )
                  : null,
              focusedBorder: OutlineInputBorder(
                borderSide: BorderSide(width: 0.4, color: ColorManager.grey),
                borderRadius: BorderRadius.circular(5),
              ),
              disabledBorder: (borderSideActive)
                  ? OutlineInputBorder(
                      borderSide:
                          BorderSide(width: 0.4, color: ColorManager.grey),
                      borderRadius: BorderRadius.circular(5),
                    )
                  : null,
              suffixIcon: (isSuffixActive)
                  ? IconButton(
                      onPressed: onSuffixPress,
                      icon: Icon(
                        suffixIcon,
                        color: Colors.grey,
                      ),
                    )
                  : null,
            ),
            style: getRegularStyle(
              color: Colors.black,
            ),
          ),
        ],
      ),
    );
  }
}
