class DateFormatCustom {
  static String monthLocal(String month) {
    switch (month) {
      case "01":
        return "Januari";
      case "02":
        return "Februari";
      case "03":
        return "Maret";
      case "04":
        return "April";
      case "05":
        return "Mei";
      case "06":
        return "Juni";
      case "07":
        return "Juli";
      case "08":
        return "Agustus";
      case "09":
        return "September";
      case "10":
        return "Oktober";
      case "11":
        return "November";
      case "12":
        return "Desember";
      default:
        return "Unknown";
    }
  }

  static String localTimeZoneName(String timeZoneOffset) {
    String timeZoneSplit = timeZoneOffset.split(":")[0];
    switch (timeZoneSplit) {
      case "7":
        return "WIB";
      case "8":
        return "WITA";
      case "9":
        return "WIT";
      default:
        return "+$timeZoneSplit";
    }
  }

  static String getLocalTime({bool timeZoneActive = false}) {
    DateTime localTime = DateTime.now().toLocal();
    int hour = localTime.hour;
    String min = localTime.minute.toString();
    String minute;
    if (min.length == 1) {
      minute = "0$min";
    } else {
      minute = min;
    }
    // int sec = localTime.second;
    String timeZone = localTimeZoneName(localTime.timeZoneOffset.toString());
    String result;

    if (timeZoneActive) {
      result = "$hour : $minute $timeZone";
    } else {
      result = "$hour : $minute";
    }

    return result;
  }

  static String getDateLocal() {
    DateTime localTime = DateTime.now().toLocal();
    int day = localTime.day;
    String month = monthLocal(localTime.month.toString());
    int year = localTime.year;

    String result = "$day $month $year";
    return result;
  }
}
