import 'package:excelso_attendance/helper/component/button.dart';
import 'package:excelso_attendance/resource/assets.dart';
import 'package:excelso_attendance/resource/colors.dart';
import 'package:excelso_attendance/resource/font.dart';
import 'package:excelso_attendance/resource/routes.dart';
import 'package:excelso_attendance/resource/size.dart';
import 'package:excelso_attendance/resource/style.dart';
import 'package:flutter/material.dart';

class AbsentSuccessView extends StatelessWidget {
  const AbsentSuccessView({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: ColorManager.backgroundColor,
      body: SingleChildScrollView(
        child: Column(
          children: [
            Container(
              height: AppPadding.safeAreaTop(context) + 60,
              width: double.infinity,
              decoration: BoxDecoration(
                borderRadius: const BorderRadius.only(
                  bottomRight: Radius.circular(20),
                  bottomLeft: Radius.circular(20),
                ),
                color: ColorManager.primary,
              ),
              child: Container(
                padding: EdgeInsets.symmetric(horizontal: AppPadding.p20),
                margin: EdgeInsets.only(
                  top: AppPadding.safeAreaTop(context),
                ),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    GestureDetector(
                      onTap: () {
                        Navigator.pushNamedAndRemoveUntil(
                          context,
                          Routes.home,
                          (route) => false,
                        );
                      },
                      child: const Icon(
                        Icons.arrow_back,
                        color: Colors.white,
                        size: 24,
                      ),
                    ),
                    Container(
                      margin: EdgeInsets.only(
                        left: AppMargin.m16,
                      ),
                      child: Text(
                        "Absen Sukses",
                        style: getBoldStyle(
                          color: Colors.white,
                          fontSize: 17,
                        ),
                      ),
                    )
                  ],
                ),
              ),
            ),
            const SizedBox(
              height: 60,
            ),
            Container(
              padding: EdgeInsets.symmetric(
                horizontal: AppPadding.p20,
              ),
              width: double.infinity,
              child: Center(
                child: Text(
                  '''Absen Masuk 
Sukses''',
                  style: getSemiBoldStyle(
                    color: Colors.black,
                    fontSize: FontSize.s24,
                    fontFamily: FontConstants.montserrat,
                  ),
                  textAlign: TextAlign.center,
                ),
              ),
            ),
            Container(
              margin: const EdgeInsets.only(
                top: 27,
              ),
              padding: EdgeInsets.symmetric(
                horizontal: AppPadding.p20,
              ),
              child: Image(
                height: 232,
                width: double.infinity,
                image: AssetImage(
                  Assets.absentSuccess,
                ),
              ),
            ),
            Container(
              width: double.infinity,
              margin: EdgeInsets.only(
                top: 38,
                left: AppMargin.m20,
                right: AppMargin.m20,
              ),
              padding: EdgeInsets.symmetric(
                vertical: AppPadding.p20,
                horizontal: 25,
              ),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(16),
                border: Border.all(
                  width: 0.2,
                  color: Colors.grey,
                ),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: Colors.grey.withOpacity(0.3),
                    blurRadius: 2,
                    offset: const Offset(5, 5),
                  ),
                ],
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Text(
                        "CRM",
                        style: getSemiBoldStyle(
                          color: ColorManager.fontBlack,
                          fontSize: FontSize.s20,
                          fontFamily: FontConstants.montserrat,
                        ),
                      ),
                      Text(
                        "10:30 WIB",
                        style: getSemiBoldStyle(
                          color: ColorManager.fontBlack,
                          fontSize: FontSize.s20,
                          fontFamily: FontConstants.montserrat,
                        ),
                      )
                    ],
                  ),
                  Container(
                    margin: EdgeInsets.only(
                      top: AppMargin.m10,
                    ),
                    child: Row(
                      children: [
                        const Spacer(),
                        Text(
                          "23 Februari 2023",
                          style: getRegularStyle(
                            color: ColorManager.fontBlack,
                            fontSize: 16,
                            fontFamily: FontConstants.montserrat,
                          ),
                        )
                      ],
                    ),
                  ),
                  Container(
                    margin: EdgeInsets.only(
                      top: AppMargin.m16,
                      left: AppMargin.m16,
                      right: AppMargin.m16,
                    ),
                    child: CustomButton(
                      text: "Kembali ke Beranda",
                      onTap: () {
                        Navigator.pushNamedAndRemoveUntil(
                          context,
                          Routes.home,
                          (route) => false,
                        );
                      },
                    ),
                  )
                ],
              ),
            )
          ],
        ),
      ),
    );
  }
}
