import 'package:excelso_attendance/helper/arguments/route_args.dart';
import 'package:excelso_attendance/helper/component/button.dart';
import 'package:excelso_attendance/helper/component/text_field.dart';
import 'package:excelso_attendance/helper/widget_responsive.dart';
import 'package:excelso_attendance/resource/assets.dart';
import 'package:excelso_attendance/resource/colors.dart';
import 'package:excelso_attendance/resource/font.dart';
import 'package:excelso_attendance/resource/routes.dart';
import 'package:excelso_attendance/resource/size.dart';
import 'package:excelso_attendance/resource/style.dart';
import 'package:flutter/material.dart';

class HomeView extends StatelessWidget {
  HomeView({super.key});

  final TextEditingController nikController = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: ColorManager.backgroundColor,
      body: ScreenResponsive(
        widget: BodyWidget(nikController: nikController),
        widthScreen: MediaQuery.of(context).size.width,
      ),
    );
  }
}

class BodyWidget extends StatelessWidget {
  const BodyWidget({
    super.key,
    required this.nikController,
  });

  final TextEditingController nikController;

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            Container(
              padding: EdgeInsets.only(
                top: AppPadding.safeAreaTop(context) + 10,
                bottom: 20,
              ),
              decoration: BoxDecoration(
                color: ColorManager.primary,
                borderRadius: const BorderRadius.only(
                  bottomLeft: Radius.circular(20),
                  bottomRight: Radius.circular(20),
                ),
              ),
              child: Center(
                child: Image(
                  width: 36,
                  height: 36,
                  image: AssetImage(
                    Assets.excelsoLogo,
                  ),
                ),
              ),
            )
          ],
        ),
        Expanded(
          child: SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                Container(
                  margin: EdgeInsets.only(
                    top: AppMargin.m16,
                  ),
                  child: Text(
                    "Attendance",
                    style: getSemiBoldStyle(
                      color: Colors.black,
                      fontSize: 20,
                      fontFamily: FontConstants.montserrat,
                    ),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(
                    top: AppMargin.m16,
                    left: AppMargin.m20,
                    right: AppMargin.m20,
                  ),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(20),
                    color: ColorManager.primary,
                  ),
                  child: Container(
                    width: double.infinity,
                    padding: const EdgeInsets.symmetric(
                      vertical: 20,
                      horizontal: 20,
                    ),
                    child: const TimerWidget(),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(
                    top: AppMargin.m16,
                    left: AppMargin.m20,
                    right: AppMargin.m20,
                  ),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8),
                    border: Border.all(
                      width: 0.2,
                      color: Colors.grey,
                    ),
                    color: ColorManager.backgroundColor,
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey.withOpacity(0.3),
                        blurRadius: 2,
                        offset: const Offset(5, 5),
                      ),
                    ],
                  ),
                  child: Container(
                    width: double.infinity,
                    padding: EdgeInsets.all(
                      AppPadding.p15,
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          "Pilih Outlet",
                          style: getSemiBoldStyle(
                            color: Colors.black,
                            fontSize: 16,
                          ),
                        ),
                        Container(
                          margin: const EdgeInsets.only(
                            top: 10,
                          ),
                          width: double.infinity,
                          decoration: BoxDecoration(
                            border: Border.all(width: 0.2, color: Colors.grey),
                            borderRadius: BorderRadius.circular(5),
                            color: ColorManager.backgroundColor,
                          ),
                          child: GestureDetector(
                            onTap: () {
                              showModalBottomSheet(
                                  backgroundColor: ColorManager.backgroundColor,
                                  isScrollControlled: true,
                                  context: context,
                                  builder: (c) {
                                    return const WidgetSelectOutlet();
                                  });
                            },
                            child: Container(
                              padding: const EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 15,
                              ),
                              child: Row(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceBetween,
                                children: [
                                  Text(
                                    "CPM",
                                    style: getRegularStyle(
                                      color: ColorManager.grey,
                                      fontSize: 16,
                                    ),
                                  ),
                                  // Icon(
                                  //   Icons.arrow_drop_down,
                                  //   color: ColorManager.grey,
                                  //   size: 30,
                                  // ),
                                  Text(
                                    "Ubah",
                                    style: getRegularStyle(
                                      color: ColorManager.link,
                                    ),
                                  )
                                ],
                              ),
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
                Container(
                  margin: EdgeInsets.only(
                    top: AppMargin.m16,
                    left: AppMargin.m20,
                    right: AppMargin.m20,
                  ),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8),
                    border: Border.all(
                      width: 0.2,
                      color: Colors.grey,
                    ),
                    color: ColorManager.backgroundColor,
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey.withOpacity(0.3),
                        blurRadius: 2,
                        offset: const Offset(5, 5),
                      ),
                    ],
                  ),
                  child: Container(
                    width: double.infinity,
                    padding: EdgeInsets.all(
                      AppPadding.p15,
                    ),
                    child: InputTextField(
                      controller: nikController,
                      labelText: "NIK",
                      borderSideActive: true,
                      hintText: "NIK",
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.symmetric(horizontal: AppPadding.p20),
                  margin: EdgeInsets.only(
                    top: AppMargin.m16,
                  ),
                  child: Row(
                    children: [
                      Expanded(
                          child: CustomButton(
                        text: "Masuk",
                        onTap: () {
                          showModalBottomSheet(
                              backgroundColor: ColorManager.backgroundColor,
                              isScrollControlled: true,
                              context: context,
                              builder: (c) {
                                return const WidgetSelectShift();
                              });
                        },
                      )),
                      SizedBox(
                        width: AppMargin.m20,
                      ),
                      Expanded(
                        child: CustomButton(
                          text: "Keluar",
                          onTap: () {
                            Navigator.pushNamed(
                              context,
                              Routes.absentCamera,
                              arguments: AbsentCameraArguments(
                                  isIn: false, outletName: "CRM"),
                            );
                          },
                        ),
                      ),
                    ],
                  ),
                )
              ],
            ),
          ),
        )
      ],
    );
  }
}

class WidgetSelectOutlet extends StatefulWidget {
  const WidgetSelectOutlet({
    Key? key,
    this.onSelected,
  }) : super(key: key);

  final void Function()? onSelected;

  @override
  State<WidgetSelectOutlet> createState() => _WidgetSelectOutletState();
}

class _WidgetSelectOutletState extends State<WidgetSelectOutlet> {
  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          padding: EdgeInsets.symmetric(horizontal: AppPadding.p20),
          margin: EdgeInsets.only(top: AppMargin.m20),
          child: Text(
            "Pilih Outlet",
            style: getMediumStyle(
                color: Colors.black,
                fontSize: 20,
                fontFamily: FontConstants.poppins),
          ),
        ),
        Container(
          padding: EdgeInsets.symmetric(horizontal: AppPadding.p20),
          margin: EdgeInsets.only(top: AppMargin.m18),
          child: Center(
            child: Text(
              "Outlet dalam radius 10 Km",
              style: getMediumStyle(
                  color: Colors.black,
                  fontSize: 16,
                  fontFamily: FontConstants.poppins),
            ),
          ),
        ),
        Container(
          height: 300,
          width: double.infinity,
          margin: EdgeInsets.only(
            top: AppMargin.m18,
            left: AppMargin.m20,
            right: AppMargin.m20,
          ),
          decoration: BoxDecoration(
            color: ColorManager.backgroundColor,
            borderRadius: BorderRadius.circular(8),
            border: Border.all(width: 0.3, color: ColorManager.grey),
            boxShadow: [
              BoxShadow(
                color: Colors.grey.withOpacity(0.3),
                blurRadius: 2,
                offset: const Offset(5, 5),
              ),
            ],
          ),
          child: ListView.builder(
            padding: EdgeInsets.zero,
            itemCount: 5,
            itemBuilder: ((context, index) {
              return Container(
                margin: const EdgeInsets.symmetric(horizontal: 6),
                padding: EdgeInsets.symmetric(
                  horizontal: AppPadding.p10,
                  vertical: AppPadding.p14,
                ),
                decoration: BoxDecoration(
                  border: (index + 1 != 5)
                      ? Border(
                          bottom: BorderSide(
                            width: 0.5,
                            color: ColorManager.grey.withOpacity(0.8),
                          ),
                        )
                      : null,
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Text(
                      "CPM ${index + 1}",
                      style: getRegularStyle(
                        color: Colors.black,
                        fontSize: 20,
                        fontFamily: FontConstants.poppins,
                      ),
                    ),
                    Text(
                      "1.2 Km",
                      style: getRegularStyle(
                        color: Colors.black,
                        fontSize: 12,
                        fontFamily: FontConstants.poppins,
                      ),
                    )
                  ],
                ),
              );
            }),
          ),
        ),
        Container(
          padding: EdgeInsets.symmetric(
            horizontal: AppPadding.p20,
          ),
          margin: EdgeInsets.symmetric(vertical: AppMargin.m16),
          child: const CustomButton(
            text: "Pilih OUtlet",
          ),
        )
      ],
    );
  }
}

class TimerWidget extends StatefulWidget {
  const TimerWidget({
    Key? key,
  }) : super(key: key);

  @override
  State<TimerWidget> createState() => _TimerWidgetState();
}

class _TimerWidgetState extends State<TimerWidget> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Text(
          "10 : 30",
          style: getSemiBoldStyle(
            color: Colors.white,
            fontSize: 48,
          ),
        ),
        Text(
          "30 Mei 2023",
          style: getSemiBoldStyle(
            color: Colors.white,
            fontSize: 14,
          ),
        ),
      ],
    );
  }
}

class WidgetSelectShift extends StatefulWidget {
  const WidgetSelectShift({
    Key? key,
    this.onSelected,
  }) : super(key: key);

  final void Function()? onSelected;

  @override
  State<WidgetSelectShift> createState() => _WidgetSelectShiftState();
}

class _WidgetSelectShiftState extends State<WidgetSelectShift> {
  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisSize: MainAxisSize.min,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          padding: EdgeInsets.symmetric(horizontal: AppPadding.p20),
          margin: EdgeInsets.only(top: AppMargin.m20),
          child: Text(
            "Pilih Shift",
            style: getMediumStyle(
                color: Colors.black,
                fontSize: 20,
                fontFamily: FontConstants.poppins),
          ),
        ),
        Container(
          height: 180,
          width: double.infinity,
          margin: EdgeInsets.only(
            top: AppMargin.m20,
            left: AppMargin.m20,
            right: AppMargin.m20,
          ),
          decoration: BoxDecoration(
            color: ColorManager.backgroundColor,
            borderRadius: BorderRadius.circular(8),
            border: Border.all(width: 0.3, color: ColorManager.grey),
            boxShadow: [
              BoxShadow(
                color: Colors.grey.withOpacity(0.3),
                blurRadius: 2,
                offset: const Offset(5, 5),
              ),
            ],
          ),
          child: ListView.builder(
            padding: EdgeInsets.zero,
            itemCount: 3,
            itemBuilder: ((context, index) {
              return Container(
                margin: const EdgeInsets.symmetric(horizontal: 6),
                padding: EdgeInsets.symmetric(
                  horizontal: AppPadding.p10,
                  vertical: AppPadding.p14,
                ),
                decoration: BoxDecoration(
                  border: (index + 1 != 3)
                      ? Border(
                          bottom: BorderSide(
                            width: 0.5,
                            color: ColorManager.grey.withOpacity(0.8),
                          ),
                        )
                      : null,
                ),
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    Text(
                      "Pagi ${index + 1}",
                      style: getRegularStyle(
                        color: Colors.black,
                        fontSize: FontSize.s16,
                        fontFamily: FontConstants.poppins,
                      ),
                    ),
                    Text(
                      "08 : 00 - 16 : 00",
                      style: getRegularStyle(
                        color: Colors.black,
                        fontSize: FontSize.s20,
                        fontFamily: FontConstants.openSans,
                      ),
                    )
                  ],
                ),
              );
            }),
          ),
        ),
        Container(
          padding: EdgeInsets.symmetric(
            horizontal: AppPadding.p20,
          ),
          margin: EdgeInsets.symmetric(vertical: AppMargin.m16),
          child: GestureDetector(
            onTap: () {
              Navigator.pop(context);
              Navigator.pushNamed(
                context,
                Routes.absentCamera,
                arguments: AbsentCameraArguments(
                  isIn: true,
                  outletName: "CRM",
                ),
              );
            },
            child: const CustomButton(
              text: "Pilih",
            ),
          ),
        )
      ],
    );
  }
}
