import 'package:excelso_attendance/helper/widget_responsive.dart';
import 'package:excelso_attendance/resource/assets.dart';
import 'package:excelso_attendance/resource/colors.dart';
import 'package:excelso_attendance/resource/font.dart';
import 'package:excelso_attendance/resource/routes.dart';
import 'package:excelso_attendance/resource/size.dart';
import 'package:excelso_attendance/resource/style.dart';
import 'package:flutter/material.dart';

class OnBoardingView extends StatelessWidget {
  const OnBoardingView({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: ColorManager.backgroundColor,
      body: ScreenResponsive(
        widget: const BodyWidget(),
        widthScreen: MediaQuery.of(context).size.width,
      ),
    );
  }
}

class BodyWidget extends StatelessWidget {
  const BodyWidget({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      child: Column(
        children: [
          Container(
            width: double.infinity,
            decoration: BoxDecoration(
              color: ColorManager.primary,
              borderRadius: const BorderRadius.only(
                bottomLeft: Radius.circular(50),
                bottomRight: Radius.circular(50),
              ),
            ),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  padding: EdgeInsets.only(
                    top: AppPadding.safeAreaTop(context) + 38,
                    left: AppPadding.p20,
                    right: AppPadding.p20,
                  ),
                  child: Center(
                    child: Image(
                      width: 119,
                      height: 46,
                      image: AssetImage(Assets.excelso),
                    ),
                  ),
                ),
                Container(
                  padding: EdgeInsets.symmetric(
                    horizontal: AppPadding.p20,
                  ),
                  margin: EdgeInsets.only(
                    top: AppMargin.m16,
                  ),
                  width: double.infinity,
                  height: 332,
                  child: Image(
                    fit: BoxFit.fill,
                    image: AssetImage(
                      Assets.onboarding,
                    ),
                  ),
                ),
                Container(
                  padding: const EdgeInsets.symmetric(
                    horizontal: 40,
                  ),
                  margin: const EdgeInsets.only(
                    top: 32,
                    bottom: 59,
                  ),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        "Attendance",
                        style: getSemiBoldStyle(
                          color: Colors.white,
                          fontSize: 24,
                          fontFamily: FontConstants.montserrat,
                        ),
                      ),
                      Text(
                        '''Memudahkan anda melakukan absen 
dengan sekali klik''',
                        style: getRegularStyle(
                          color: Colors.white,
                          fontSize: 12,
                        ),
                      )
                    ],
                  ),
                )
              ],
            ),
          ),
          GestureDetector(
            onTap: () {
              Navigator.pushNamed(context, Routes.home);
            },
            child: Container(
              margin: const EdgeInsets.only(
                top: 60,
              ),
              child: Center(
                child: Container(
                  width: 60,
                  height: 60,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(100),
                    color: ColorManager.primary,
                  ),
                  child: const Center(
                    child: Icon(
                      Icons.arrow_forward_ios_rounded,
                      color: Colors.white,
                      size: 23,
                    ),
                  ),
                ),
              ),
            ),
          ),
          Container(
            margin: const EdgeInsets.only(
              top: 30,
            ),
            child: Text(
              "Since © 2023",
              style: getMediumStyle(
                color: Colors.black,
              ),
            ),
          )
        ],
      ),
    );
  }
}
