import 'package:excelso_attendance/helper/arguments/route_args.dart';
import 'package:excelso_attendance/main.dart';
import 'package:excelso_attendance/page/absent_camera/absent_camera.dart';
import 'package:excelso_attendance/page/absent_success/absent_success.dart';
import 'package:excelso_attendance/page/home/home.dart';
import 'package:excelso_attendance/page/onboarding/onboarding.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class Routes {
  static const String onBoarding = "/onboarding";
  static const String home = "/home";
  static const String absentCamera = "/absent-camera";
  static const String absentSuccess = "/absent-success";
}

class RouteGenerator {
  static Route<dynamic> getRoute(RouteSettings routeSettings) {
    switch (routeSettings.name) {
      case Routes.onBoarding:
        return pageRouteCustom(const OnBoardingView(),
            nameRoute: Routes.onBoarding);
      case Routes.home:
        return pageRouteCustom(HomeView(), nameRoute: Routes.home);
      case Routes.absentCamera:
        AbsentCameraArguments args =
            routeSettings.arguments as AbsentCameraArguments;
        return pageRouteCustom(
          AbsentCameraView(
            outletName: args.outletName,
            isIn: args.isIn,
          ),
          nameRoute: Routes.absentCamera,
          routeSettings: routeSettings,
        );
      case Routes.absentSuccess:
        return pageRouteCustom(const AbsentSuccessView(),
            nameRoute: Routes.absentSuccess);
      default:
        return unDefinedRoute();
    }
  }

  static void setTitle(String title) {
    SystemChrome.setApplicationSwitcherDescription(
      ApplicationSwitcherDescription(label: "$title | $titleApp"),
    );
  }

  static PageRouteBuilder<dynamic> pageRouteCustom(
    Widget target, {
    required String nameRoute,
    String title = "",
    RouteSettings? routeSettings,
  }) {
    // setTitle(title);
    if (nameRoute == Routes.absentCamera) {
      AbsentCameraArguments args =
          routeSettings!.arguments as AbsentCameraArguments;
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => AbsentCameraView(
          outletName: args.outletName,
          isIn: args.isIn,
        ),
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        settings: RouteSettings(
            name: nameRoute.replaceFirst("/", ""), arguments: args),
      );
    } else {
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => target,
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        settings: RouteSettings(name: nameRoute.replaceFirst("/", "")),
      );
    }
  }

  static Route<dynamic> unDefinedRoute() {
    return MaterialPageRoute(
      builder: (_) => Scaffold(
        appBar: AppBar(
          title: const Text("No Route Found"),
        ),
        body: const Center(
          child: Text("No Route Found"),
        ),
      ),
    );
  }
}
