import 'package:ravintola_attendance/helper/component/text_field.dart';
import 'package:flutter/material.dart';

class PasswordInput extends StatefulWidget {
  const PasswordInput({
    Key? key,
    required this.passwordController,
    this.onChanged,
    this.labelText = "Password",
    this.labelColor,
    this.marginTop,
    this.borderSideActive = false,
    this.textInputType = TextInputType.text,
  }) : super(key: key);

  final TextEditingController passwordController;
  final void Function(String val)? onChanged;
  final String labelText;
  final Color? labelColor;
  final double? marginTop;
  final bool borderSideActive;
  final TextInputType textInputType;

  @override
  State<PasswordInput> createState() => _PasswordInputState();
}

class _PasswordInputState extends State<PasswordInput> {
  bool secure = true;
  @override
  Widget build(BuildContext context) {
    return InputTextField(
      controller: widget.passwordController,
      labelText: widget.labelText,
      labelColor: widget.labelColor,
      marginTop: widget.marginTop,
      marginActive: false,
      onChanged: widget.onChanged,
      secure: secure,
      isSuffixActive: true,
      borderSideActive: widget.borderSideActive,
      hintText: widget.labelText,
      inputType: widget.textInputType,
      suffixIcon: (secure) ? Icons.visibility_off : Icons.visibility,
      onSuffixPress: () {
        setState(() {
          secure = !secure;
        });
      },
    );
  }
}
