class ProfileModel {
  String id;
  String brand;
  String name;
  bool attendanceIn;
  bool attendanceOut;
  String shiftSelectedName;
  String shiftStart;
  String shiftEnd;

  ProfileModel({
    required this.id,
    required this.brand,
    required this.name,
    required this.attendanceIn,
    required this.attendanceOut,
    required this.shiftSelectedName,
    required this.shiftStart,
    required this.shiftEnd,
  });

  factory ProfileModel.json(Map<String, dynamic> json) {
    return ProfileModel(
      id: json['id'],
      brand: json['brand'],
      name: json['name'],
      attendanceIn: json['today_attendance_in'],
      attendanceOut: json['today_attendance_out'],
      shiftSelectedName: json['shift_name'] ?? "",
      shiftStart: json['shift_start'] ?? "",
      shiftEnd: json['shift_end'] ?? "",
    );
  }
}
