import 'package:ravintola_attendance/models/absent.dart';
import 'package:ravintola_attendance/models/branch.dart';
import 'package:ravintola_attendance/models/profile.dart';
import 'package:ravintola_attendance/models/shift.dart';

class AbsentCameraArguments {
  final int actionType; // 1 = Absent, 2 = Break
  final bool isIn;
  final BranchModel branchModel;
  final ShiftModel? shiftModel;
  final ProfileModel profile;
  final String nik;
  final String shiftNameSelected;
  final String shiftStartTime;
  final String shiftEndTime;

  AbsentCameraArguments({
    this.actionType = 1,
    required this.isIn,
    required this.branchModel,
    required this.nik,
    required this.profile,
    required this.shiftStartTime,
    required this.shiftEndTime,
    this.shiftModel,
    required this.shiftNameSelected,
  });
}

class HomeArguments {
  final List<BranchModel> branchModel;
  final List<ShiftModel> shiftModel;

  HomeArguments({
    required this.branchModel,
    required this.shiftModel,
  });
}

class AbsentSuccessArguments {
  final AbsentSuccessModel absentSuccess;
  final ProfileModel profil;
  final String nik;
  final int actionType;
  final bool isIn;
  final String shiftStart;
  final String shiftEnd;
  final String shiftName;

  AbsentSuccessArguments({
    required this.absentSuccess,
    required this.profil,
    required this.nik,
    required this.actionType,
    required this.isIn,
    required this.shiftStart,
    required this.shiftEnd,
    required this.shiftName,
  });
}
