import 'package:ravintola_attendance/resource/colors.dart';
import 'package:ravintola_attendance/resource/style.dart';
import 'package:flutter/material.dart';

class CustomButton extends StatelessWidget {
  const CustomButton({
    Key? key,
    required this.text,
    this.colorText = Colors.white,
    this.colorButton,
    this.onTap,
  }) : super(key: key);

  final String text;
  final Color colorText;
  final Color? colorButton;
  final void Function()? onTap;

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: onTap,
      child: Container(
        width: double.infinity,
        height: 55,
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8),
          color: (colorButton == null) ? ColorManager.primary : colorButton,
        ),
        child: Center(
          child: Text(
            text,
            style: getSemiBoldStyle(
              color: colorText,
            ),
          ),
        ),
      ),
    );
  }
}
