import 'package:ravintola_attendance/helper/component/button.dart';
import 'package:ravintola_attendance/helper/global_function/date_time.dart';
import 'package:ravintola_attendance/helper/widget_responsive.dart';
import 'package:ravintola_attendance/models/absent.dart';
import 'package:ravintola_attendance/models/profile.dart';
import 'package:ravintola_attendance/resource/assets.dart';
import 'package:ravintola_attendance/resource/colors.dart';
import 'package:ravintola_attendance/resource/font.dart';
import 'package:ravintola_attendance/resource/routes.dart';
import 'package:ravintola_attendance/resource/size.dart';
import 'package:ravintola_attendance/resource/style.dart';
import 'package:flutter/material.dart';

String getAbsentText(bool isIn, int actionType) {
  var msg = "";
  if (actionType == 1) {
    msg = isIn ? "Absen Masuk" : "Absen Keluar";
  } else if (actionType == 2) {
    msg = isIn ? "Break Start" : "Break End";
  }
  // msg += " isIn: $isIn, actionType: $actionType";
  return msg;
}

class AbsentSuccessView extends StatelessWidget {
  const AbsentSuccessView({
    super.key,
    required this.absentSuccess,
    required this.isIn,
    required this.actionType,
    required this.nik,
    required this.profil,
    required this.shiftStart,
    required this.shiftEnd,
    required this.shiftName,
  });

  final AbsentSuccessModel absentSuccess;
  final ProfileModel profil;
  final String nik;
  final int actionType;
  final bool isIn;
  final String shiftStart;
  final String shiftEnd;
  final String shiftName;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: ColorManager.backgroundColor,
      body: ScreenResponsive(
        widget: BodyWidget(
          actionType: actionType,
          isIn: isIn,
          profil: profil,
          nik: nik,
          absentSuccess: absentSuccess,
          shiftEnd: shiftEnd,
          shiftName: shiftName,
          shiftStart: shiftStart,
        ),
        widthScreen: MediaQuery.of(context).size.width,
      ),
    );
  }
}

class BodyWidget extends StatelessWidget {
  const BodyWidget({
    super.key,
    required this.actionType,
    required this.isIn,
    required this.profil,
    required this.nik,
    required this.absentSuccess,
    required this.shiftStart,
    required this.shiftEnd,
    required this.shiftName,
  });

  final int actionType;
  final bool isIn;
  final ProfileModel profil;
  final String nik;
  final AbsentSuccessModel absentSuccess;
  final String shiftStart;
  final String shiftEnd;
  final String shiftName;

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      child: Column(
        children: [
          Container(
            height: AppPadding.safeAreaTop(context) + 60,
            width: double.infinity,
            decoration: BoxDecoration(
              borderRadius: const BorderRadius.only(
                bottomRight: Radius.circular(20),
                bottomLeft: Radius.circular(20),
              ),
              color: ColorManager.primary,
            ),
            child: Container(
              padding: EdgeInsets.symmetric(horizontal: AppPadding.p20),
              margin: EdgeInsets.only(
                top: AppPadding.safeAreaTop(context),
              ),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  GestureDetector(
                    onTap: () {
                      Navigator.pushNamedAndRemoveUntil(
                        context,
                        Routes.onBoarding,
                        (route) => false,
                      );
                    },
                    child: const Icon(
                      Icons.arrow_back,
                      color: Colors.white,
                      size: 24,
                    ),
                  ),
                  Container(
                    margin: EdgeInsets.only(
                      left: AppMargin.m16,
                    ),
                    child: Text(
                      "Absen Sukses",
                      style: getBoldStyle(
                        color: Colors.white,
                        fontSize: 17,
                      ),
                    ),
                  )
                ],
              ),
            ),
          ),
          const SizedBox(
            height: 20,
          ),
          Container(
            padding: EdgeInsets.symmetric(
              horizontal: AppPadding.p20,
            ),
            width: double.infinity,
            child: Center(
              child: Text(
                getAbsentText(isIn, actionType),
                style: getSemiBoldStyle(
                  color: Colors.black,
                  fontSize: FontSize.s24,
                  fontFamily: FontConstants.montserrat,
                ),
                textAlign: TextAlign.center,
              ),
            ),
          ),
          Container(
            margin: const EdgeInsets.only(
              top: 27,
            ),
            padding: EdgeInsets.symmetric(
              horizontal: AppPadding.p20,
            ),
            child: Image(
              height: MediaQuery.of(context).size.height * 0.25,
              width: double.infinity,
              image: AssetImage(
                Assets.absentSuccess,
              ),
            ),
          ),
          // branch name
          Container(
            margin: EdgeInsets.only(
              top: AppMargin.m20,
              left: AppMargin.m20,
              right: AppMargin.m20,
            ),
            padding: EdgeInsets.all(AppPadding.p20),
            width: double.infinity,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(12),
              border: Border.all(
                width: 0.2,
                color: ColorManager.grey.withOpacity(
                  0.3,
                ),
              ),
              color: ColorManager.backgroundColor,
              // boxShadow: [
              //   BoxShadow(
              //     color: Colors.grey.withOpacity(0.3),
              //     blurRadius: 1,
              //     offset: const Offset(0.1, 0.1),
              //   ),
              // ],
            ),
            child: Center(
              child: Text(
                absentSuccess.branchName,
                style: getSemiBoldStyle(
                  color: ColorManager.fontBlack,
                  fontSize: FontSize.s16,
                ),
              ),
            ),
          ),
          // tanggal dan jam masuk
          Container(
            margin: EdgeInsets.only(
              top: AppMargin.m8,
              left: AppMargin.m20,
              right: AppMargin.m20,
            ),
            padding: EdgeInsets.all(AppPadding.p20),
            width: double.infinity,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(12),
              border: Border.all(
                width: 0.2,
                color: ColorManager.grey.withOpacity(
                  0.3,
                ),
              ),
              color: ColorManager.backgroundColor,
              // boxShadow: [
              //   BoxShadow(
              //     color: Colors.grey.withOpacity(0.3),
              //     blurRadius: 1,
              //     offset: const Offset(0.1, 0.1),
              //   ),
              // ],
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  DateFormatCustom.getDateLocal(
                    fromApi: true,
                    apiDate: absentSuccess.date,
                  ),
                  style: getRegularStyle(
                    color: ColorManager.fontBlack,
                    fontSize: FontSize.s16,
                    fontFamily: FontConstants.k2d,
                  ),
                ),
                Text(
                  "${absentSuccess.time} ${absentSuccess.timeZone}",
                  style: getRegularStyle(
                    color: ColorManager.fontBlack,
                    fontSize: FontSize.s16,
                    fontFamily: FontConstants.k2d,
                  ),
                )
              ],
            ),
          ),
          SizedBox(
            height: AppMargin.m8,
          ),
          // nama , NIK, dan Shift
          Container(
            margin: EdgeInsets.symmetric(
              horizontal: AppMargin.m20,
            ),
            padding: EdgeInsets.symmetric(
              horizontal: AppPadding.p12,
              vertical: AppPadding.p20,
            ),
            width: double.infinity,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(12),
              border: Border.all(
                width: 0.2,
                color: ColorManager.grey.withOpacity(
                  0.3,
                ),
              ),
            ),
            child: Column(
              children: [
                Container(
                  padding: EdgeInsets.only(
                    bottom: AppPadding.p12,
                  ),
                  width: double.infinity,
                  decoration: BoxDecoration(
                    border: Border(
                      bottom: BorderSide(
                        width: 1,
                        color: ColorManager.grey.withOpacity(
                          0.3,
                        ),
                      ),
                    ),
                  ),
                  child: Column(
                    children: [
                      Text(
                        profil.name,
                        style: getSemiBoldStyle(
                          color: Colors.black,
                          fontSize: FontSize.s16,
                          fontFamily: FontConstants.k2d,
                        ),
                        textAlign: TextAlign.center,
                        maxLines: 1,
                        overflow: TextOverflow.ellipsis,
                      ),
                      SizedBox(
                        height: AppMargin.m8,
                      ),
                      Text(
                        nik,
                        style: getMediumStyle(
                          color: ColorManager.green2,
                          fontSize: FontSize.s16,
                          fontFamily: FontConstants.k2d,
                        ),
                        textAlign: TextAlign.center,
                        maxLines: 1,
                        overflow: TextOverflow.ellipsis,
                      ),
                    ],
                  ),
                ),
                Container(
                  padding: EdgeInsets.only(
                    top: AppPadding.p12,
                    bottom: AppPadding.p20,
                  ),
                  child: Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: Text(
                          shiftName,
                          style: getRegularStyle(
                            color: ColorManager.fontBlack,
                            fontSize: FontSize.s14,
                            fontFamily: FontConstants.k2d,
                          ),
                        ),
                      ),
                      SizedBox(
                        width: AppMargin.m10,
                      ),
                      Expanded(
                        child: Text(
                          "$shiftStart - $shiftEnd",
                          style: getRegularStyle(
                            color: ColorManager.fontBlack,
                            fontSize: FontSize.s14,
                            fontFamily: FontConstants.k2d,
                          ),
                          textAlign: TextAlign.end,
                        ),
                      ),
                    ],
                  ),
                )
              ],
            ),
          ),
          SizedBox(
            height: AppMargin.m16,
          ),
          Container(
            margin: EdgeInsets.symmetric(
              horizontal: AppMargin.m20,
            ),
            child: CustomButton(
              text: "Kembali ke Beranda",
              onTap: () {
                Navigator.pushNamedAndRemoveUntil(
                  context,
                  Routes.onBoarding,
                  (route) => false,
                );
              },
            ),
          )
        ],
      ),
    );
  }
}
