class DateFormatCustom {
  static String monthLocal(String m) {
    String month;
    if (m.length == 1) {
      month = "0$m";
    } else {
      month = m;
    }
    switch (month) {
      case "01":
        return "Januari";
      case "02":
        return "Februari";
      case "03":
        return "Maret";
      case "04":
        return "April";
      case "05":
        return "Mei";
      case "06":
        return "Juni";
      case "07":
        return "Juli";
      case "08":
        return "Agustus";
      case "09":
        return "September";
      case "10":
        return "Oktober";
      case "11":
        return "November";
      case "12":
        return "Desember";
      default:
        return "Unknown";
    }
  }

  static String localTimeZoneName(String timeZoneOffset) {
    String timeZoneSplit = timeZoneOffset.split(":")[0];
    switch (timeZoneSplit) {
      case "7":
        return "WIB";
      case "8":
        return "WITA";
      case "9":
        return "WIT";
      default:
        return "+$timeZoneSplit";
    }
  }

  static String getLocalTime(
      {bool timeZoneActive = false, bool secondActive = false}) {
    DateTime localTime = DateTime.now().toLocal();
    int hour = localTime.hour;
    String min = localTime.minute.toString();
    String second = localTime.second.toString();
    String minute;
    String sec;
    if (min.length == 1) {
      minute = "0$min";
    } else {
      minute = min;
    }

    if (second.length == 1) {
      sec = "0$second";
    } else {
      sec = second;
    }
    // int sec = localTime.second;
    String timeZone = localTimeZoneName(localTime.timeZoneOffset.toString());
    String result;

    if (timeZoneActive) {
      if (secondActive) {
        result = "$hour : $minute : $sec $timeZone";
      } else {
        result = "$hour : $minute $timeZone";
      }
    } else {
      if (secondActive) {
        result = "$hour : $minute : $sec";
      } else {
        result = "$hour : $minute";
      }
    }

    return result;
  }

  static String getDateLocal({
    bool fromApi = false,
    String apiDate = '',
  }) {
    String day;
    String month;
    String year;

    if (fromApi) {
      List<String> splitApiDate = apiDate.split("-");
      day = splitApiDate[2];
      month = monthLocal(splitApiDate[1]);
      year = splitApiDate[0];
    } else {
      DateTime localTime = DateTime.now().toLocal();
      day = localTime.day.toString();
      month = monthLocal(localTime.month.toString());
      year = localTime.year.toString();
    }

    String result = "$day $month $year";
    return result;
  }

  static String getTimeHourMinuteOnly(String time) {
    // awalnya dari API 00:00:00, balikin 00:00 ke UI
    List<String> timeSplit = time.split(":");

    String result;
    result = "${timeSplit[0]} : ${timeSplit[1]}";
    return result;
  }
}
