// ignore_for_file: must_be_immutable

import 'package:ravintola_attendance/resource/colors.dart';
import 'package:flutter/material.dart';

class ScreenResponsive extends StatefulWidget {
  Widget widget;
  double widthScreen;
  bool isCoreLayout;
  Color? sideColor;
  ScreenResponsive({
    Key? key,
    required this.widget,
    required this.widthScreen,
    this.isCoreLayout = true,
    this.sideColor,
  }) : super(key: key);

  @override
  State<ScreenResponsive> createState() => _ScreenResponsiveState();
}

class _ScreenResponsiveState extends State<ScreenResponsive> {
  @override
  Widget build(BuildContext context) {
    double maxWidthScreen = getMaxWidthScreen(context, true);
    if (widget.widthScreen > maxWidthScreen) {
      double leftRight = (widget.widthScreen - maxWidthScreen) / 2;
      if (widget.isCoreLayout) {
        return Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Container(
              width: leftRight,
              height: MediaQuery.of(context).size.height,
              color: (widget.sideColor == null)
                  ? ColorManager.grey
                  : widget.sideColor,
            ),
            SizedBox(
              width: maxWidthScreen,
              child: widget.widget,
            ),
            Container(
              width: leftRight,
              height: MediaQuery.of(context).size.height,
              color: (widget.sideColor == null)
                  ? ColorManager.grey
                  : widget.sideColor,
            )
          ],
        );
      } else {
        return Center(
          child: widget.widget,
        );
      }
    } else {
      return widget.widget;
    }
  }
}

const double maxWidthScreens = 500;

double getMaxWidthScreen(context, bool useResponsive) {
  double widhtScreen = MediaQuery.of(context).size.width;
  if (useResponsive) {
    return maxWidthScreens;
  } else {
    return widhtScreen;
  }
}
