// ignore_for_file: sized_box_for_whitespace

import 'package:ravintola_attendance/helper/component/button.dart';
import 'package:ravintola_attendance/helper/widget_responsive.dart';
import 'package:ravintola_attendance/main.dart';
import 'package:ravintola_attendance/resource/colors.dart';
import 'package:ravintola_attendance/resource/size.dart';
import 'package:ravintola_attendance/resource/strings.dart';
import 'package:ravintola_attendance/resource/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:geolocator/geolocator.dart';

class ErrorWidgetView extends StatelessWidget {
  const ErrorWidgetView({super.key, required this.messageError});

  final String messageError;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: ColorManager.backgroundColor,
      body: ScreenResponsive(
        widget: Container(
          width: double.infinity,
          height: double.infinity,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              Container(
                margin: EdgeInsets.symmetric(horizontal: AppMargin.m20),
                child: const Icon(
                  Icons.dangerous_outlined,
                  color: Colors.red,
                  size: 150,
                ),
              ),
              Padding(
                padding: EdgeInsets.symmetric(
                  horizontal: AppPadding.p20,
                ),
                child: Text(
                  messageError,
                  style: getBoldStyle(
                    color: Colors.black,
                    fontSize: 16,
                  ),
                  textAlign: TextAlign.center,
                ),
              ),
              (messageError == Strings.locationNotActive)
                  ? GestureDetector(
                      onTap: () {
                        Geolocator.requestPermission().then((value) async {
                          if (value != LocationPermission.denied &&
                              value != LocationPermission.deniedForever) {
                            // ignore: use_build_context_synchronously
                            Navigator.pushReplacement(
                              context,
                              MaterialPageRoute(
                                builder: (_) => const MyApp(),
                              ),
                            );
                          } else {
                            EasyLoading.showToast(
                                'Silakan aktifkan lokasi browser anda');
                            return;
                          }
                        });
                      },
                      child: Container(
                        margin: EdgeInsets.only(
                            top: 15, left: AppMargin.m20, right: AppMargin.m20),
                        child: const CustomButton(text: "Refresh Halaman"),
                      ),
                    )
                  : const SizedBox()
            ],
          ),
        ),
        widthScreen: MediaQuery.of(context).size.width,
      ),
    );
  }
}
