import 'package:ravintola_attendance/resource/font.dart';
import 'package:flutter/material.dart';

TextStyle _getStyle(
    double fontSize, String fontFamily, FontWeight fontWeight, Color color) {
  return TextStyle(
    fontSize: fontSize,
    fontFamily: fontFamily,
    color: color,
    fontWeight: fontWeight,
  );
}

// regularStyle
TextStyle getLightStyle({
  double fontSize = FontSize.s14,
  String fontFamily = FontConstants.openSans,
  required Color color,
}) {
  return _getStyle(
    fontSize,
    fontFamily,
    FontWeightManager.light,
    color,
  );
}

// regularStyle
TextStyle getRegularStyle({
  double fontSize = FontSize.s14,
  String fontFamily = FontConstants.openSans,
  required Color color,
}) {
  return _getStyle(
    fontSize,
    fontFamily,
    FontWeightManager.regular,
    color,
  );
}

TextStyle getMediumStyle({
  double fontSize = FontSize.s14,
  String fontFamily = FontConstants.openSans,
  required Color color,
}) {
  return _getStyle(
    fontSize,
    fontFamily,
    FontWeightManager.medium,
    color,
  );
}

TextStyle getSemiBoldStyle({
  double fontSize = FontSize.s14,
  String fontFamily = FontConstants.openSans,
  required Color color,
}) {
  return _getStyle(
    fontSize,
    fontFamily,
    FontWeightManager.semiBold,
    color,
  );
}

TextStyle getBoldStyle({
  double fontSize = FontSize.s14,
  String fontFamily = FontConstants.openSans,
  required Color color,
}) {
  return _getStyle(
    fontSize,
    fontFamily,
    FontWeightManager.bold,
    color,
  );
}
