import 'package:excelso_attendance/helper/component/button.dart';
import 'package:excelso_attendance/resource/font.dart';
import 'package:excelso_attendance/resource/style.dart';
import 'package:flutter/material.dart';

Future<dynamic> modalDialogGlobal({
  required BuildContext context,
  required Size size,
  required String title,
  required String contentBody,
  required String buttonText,
  required void Function() tapButtonOk,
  void Function()? tapButtonCancel,
  bool isActiveCancelButton = false,
  bool isCustomSecondButton = false,
  String customSecondButtonText = '',
  String cancelButtonText = "Batal",
  Widget? navigateToCustomButton,
}) async {
  return showDialog(
    context: context,
    barrierDismissible: false,
    builder: (BuildContext ctxDialog) => AlertDialog(
      shape: const RoundedRectangleBorder(
          borderRadius: BorderRadius.all(Radius.circular(15))),
      content: Column(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title,
            style: getBoldStyle(
              color: Colors.black,
              fontFamily: FontConstants.montserrat,
              fontSize: FontSize.s24,
            ),
          ),
          const SizedBox(
            height: 16,
          ),
          Text(
            contentBody,
            style: getMediumStyle(
              color: Colors.black,
              fontFamily: FontConstants.openSans,
              fontSize: FontSize.s16,
            ),
          ),
          const SizedBox(
            height: 42,
          ),
          InkWell(
            onTap: () {
              tapButtonOk();
            },
            child: CustomButton(
              text: buttonText,
            ),
          ),
          (isActiveCancelButton)
              ? InkWell(
                  onTap: () {
                    tapButtonCancel!();
                  },
                  child: CustomButton(
                    text: cancelButtonText,
                    colorButton: Colors.transparent,
                    colorText: Colors.black,
                  ),
                )
              : const SizedBox(),
          (isCustomSecondButton)
              ? Column(
                  children: [
                    const SizedBox(
                      height: 10,
                    ),
                    InkWell(
                      onTap: () {
                        Navigator.pop(context);
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (_) => navigateToCustomButton!),
                        );
                      },
                      child: CustomButton(
                        text: customSecondButtonText,
                      ),
                    ),
                  ],
                )
              : const SizedBox()
        ],
      ),
    ),
  );
}
