import 'dart:convert';

import 'package:excelso_attendance/resource/routes.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyloading/flutter_easyloading.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:url_strategy/url_strategy.dart';
import 'package:flutter/services.dart' as bundle_root;

// all config here
late bool debug;
late SharedPreferences prefs;
late String titleApp;

late String brandCode;

late String baseUrl;
late String endPoint;
late String companyName;

// final GlobalKey<NavigatorState> navigatorKey = GlobalKey<NavigatorState>();

void main() async {
  WidgetsFlutterBinding.ensureInitialized();

  setPathUrlStrategy();
  configLoading();
  await loadConfigFile();
  SharedPreferences.getInstance().then((value) {
    prefs = value;
    runApp(const MyApp());
  });
}

//easy loading
void configLoading() {
  EasyLoading.instance
    ..displayDuration = const Duration(milliseconds: 2000)
    ..indicatorType = EasyLoadingIndicatorType.fadingCircle
    ..loadingStyle = EasyLoadingStyle.dark
    ..indicatorSize = 45.0
    ..radius = 10.0
    ..progressColor = Colors.yellow
    ..backgroundColor = Colors.green
    ..indicatorColor = Colors.yellow
    ..textColor = Colors.yellow
    ..maskColor = Colors.blue.withOpacity(0.5)
    ..userInteractions = true
    ..dismissOnTap = false;
}

Future<void> loadConfigFile() async {
  String datas = await bundle_root.rootBundle.loadString('config.json');
  var decodeJson = jsonDecode(datas);
  titleApp = decodeJson['title'].toString();
  brandCode = decodeJson['brand'].toString();
  baseUrl = decodeJson['base_url'].toString();
  endPoint = decodeJson['end_point'].toString();
  debug = decodeJson['debug'];
  companyName = decodeJson['company'].toString();
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: titleApp,
      // navigatorKey: navigatorKey,
      debugShowCheckedModeBanner: false,
      onGenerateRoute: RouteGenerator.getRoute,
      initialRoute: Routes.onBoarding,
      builder: EasyLoading.init(),
    );
  }
}
