import 'package:excelso_attendance/helper/arguments/error_args.dart';
import 'package:excelso_attendance/helper/arguments/route_args.dart';
import 'package:excelso_attendance/main.dart';
import 'package:excelso_attendance/page/absent_camera/absent_camera.dart';
import 'package:excelso_attendance/page/absent_success/absent_success.dart';
import 'package:excelso_attendance/page/error/error_widget.dart';
import 'package:excelso_attendance/page/home/home.dart';
import 'package:excelso_attendance/page/onboarding/onboarding.dart';
import 'package:excelso_attendance/resource/strings.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class Routes {
  static const String onBoarding = "/onboarding";
  static const String home = "/home";
  static const String absentCamera = "/absent-camera";
  static const String absentSuccess = "/absent-success";
  static const String errorWidget = "/error";
  static const String notFoundPage = "/404";
}

class RouteGenerator {
  static Route<dynamic> getRoute(RouteSettings routeSettings) {
    switch (routeSettings.name) {
      case Routes.onBoarding:
        return pageRouteCustom(const OnBoardingView(),
            nameRoute: Routes.onBoarding);
      case Routes.home:
        HomeArguments args = routeSettings.arguments as HomeArguments;
        return pageRouteCustom(
          HomeView(
            nearestBranch: args.branchModel,
            shiftList: args.shiftModel,
          ),
          nameRoute: Routes.home,
          routeSettings: routeSettings,
        );

      case Routes.absentCamera:
        AbsentCameraArguments args =
            routeSettings.arguments as AbsentCameraArguments;
        return pageRouteCustom(
          AbsentCameraView(
            isIn: args.isIn,
            branchModel: args.branchModel,
            shiftModel: args.shiftModel,
            profile: args.profile,
            nik: args.nik,
            shiftNameSelected: args.shiftNameSelected,
            shiftStartTime: args.shiftStartTime,
            shiftEndTime: args.shiftEndTime,
          ),
          nameRoute: Routes.absentCamera,
          routeSettings: routeSettings,
        );
      case Routes.absentSuccess:
        AbsentSuccessArguments args =
            routeSettings.arguments as AbsentSuccessArguments;
        return pageRouteCustom(
          AbsentSuccessView(
            absentSuccess: args.absentSuccess,
            profil: args.profil,
            nik: args.nik,
            isIn: args.isIn,
            shiftEnd: args.shiftEnd,
            shiftStart: args.shiftStart,
            shiftName: args.shiftName,
          ),
          nameRoute: Routes.absentSuccess,
          routeSettings: routeSettings,
        );
      case Routes.errorWidget:
        ErrorWidgetArguments args =
            routeSettings.arguments as ErrorWidgetArguments;
        return pageRouteCustom(
          ErrorWidgetView(
            messageError: args.errorMessage,
          ),
          nameRoute: Routes.errorWidget,
          routeSettings: routeSettings,
        );
      default:
        return pageRouteCustom(
          ErrorWidgetView(
            messageError: Strings.notFoundPage,
          ),
          nameRoute: Routes.notFoundPage,
          routeSettings: routeSettings,
        );
    }
  }

  static void setTitle(String title) {
    SystemChrome.setApplicationSwitcherDescription(
      ApplicationSwitcherDescription(label: "$title | $titleApp"),
    );
  }

  static PageRouteBuilder<dynamic> pageRouteCustom(
    Widget target, {
    required String nameRoute,
    String title = "",
    RouteSettings? routeSettings,
  }) {
    // setTitle(title);
    if (nameRoute == Routes.absentCamera) {
      AbsentCameraArguments args =
          routeSettings!.arguments as AbsentCameraArguments;
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => AbsentCameraView(
          isIn: args.isIn,
          branchModel: args.branchModel,
          shiftModel: args.shiftModel,
          profile: args.profile,
          nik: args.nik,
          shiftNameSelected: args.shiftNameSelected,
          shiftStartTime: args.shiftStartTime,
          shiftEndTime: args.shiftEndTime,
        ),
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        // settings: RouteSettings(
        //     name: nameRoute.replaceFirst("/", ""), arguments: args),
      );
    } else if (nameRoute == Routes.errorWidget) {
      ErrorWidgetArguments args =
          routeSettings!.arguments as ErrorWidgetArguments;
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => ErrorWidgetView(
          messageError: args.errorMessage,
        ),
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        // settings: RouteSettings(
        //     name: nameRoute.replaceFirst("/", ""), arguments: args),
      );
    } else if (nameRoute == Routes.home) {
      HomeArguments args = routeSettings!.arguments as HomeArguments;
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => HomeView(
          nearestBranch: args.branchModel,
          shiftList: args.shiftModel,
        ),
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        // settings: RouteSettings(
        //     name: nameRoute.replaceFirst("/", ""), arguments: args),
      );
    } else if (nameRoute == Routes.absentSuccess) {
      AbsentSuccessArguments args =
          routeSettings!.arguments as AbsentSuccessArguments;
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => AbsentSuccessView(
          absentSuccess: args.absentSuccess,
          profil: args.profil,
          nik: args.nik,
          isIn: args.isIn,
          shiftEnd: args.shiftEnd,
          shiftStart: args.shiftStart,
          shiftName: args.shiftName,
        ),
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        // settings: RouteSettings(
        //     name: nameRoute.replaceFirst("/", ""), arguments: args),
      );
    } else {
      return PageRouteBuilder(
        pageBuilder: (context, a, b) => target,
        transitionDuration: Duration.zero,
        reverseTransitionDuration: Duration.zero,
        // settings: RouteSettings(name: nameRoute.replaceFirst("/", "")),
      );
    }
  }

  static Route<dynamic> unDefinedRoute() {
    return MaterialPageRoute(
      builder: (_) => Scaffold(
        appBar: AppBar(
          title: const Text("No Route Found"),
        ),
        body: const Center(
          child: Text("No Route Found"),
        ),
      ),
    );
  }
}
