class ConfigDisplay {
  final String backgroundColorCarouselVideo;
  final String textColor;
  final String backgroundColorOrder;
  final String mediaType;
  final String youtubeId;
  final String videoPromotionUrl;
  final String images;

  ConfigDisplay(
      {required this.backgroundColorCarouselVideo,
      required this.textColor,
      required this.backgroundColorOrder,
      required this.mediaType,
      required this.youtubeId,
      required this.videoPromotionUrl,
      required this.images});

  factory ConfigDisplay.createConfig(Map<String, dynamic> json) {
    return ConfigDisplay(
        backgroundColorCarouselVideo:
            json['background_color_carousel_video'].toString(),
        textColor: json['text_color'].toString(),
        backgroundColorOrder: json['background_color_order'],
        mediaType: json['media_type'],
        youtubeId: json['youtube_id'],
        videoPromotionUrl: json['video_promotion_url'],
        images: json['images']);
  }
}
