import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';
import 'package:second_display/ui/error.dart';

class InputBaseUrl extends StatefulWidget {
  const InputBaseUrl({Key? key}) : super(key: key);

  @override
  State<InputBaseUrl> createState() => _InputBaseUrlState();
}

class _InputBaseUrlState extends State<InputBaseUrl> {
  final _baseUrlController = TextEditingController();
  late String urlBase;
  @override
  void initState() {
    final String? _baseUrls = prefs.getString('baseUrl');
    urlBase = _baseUrls ?? urlDefault;
    _baseUrlController.text = urlBase;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Center(
        child: Container(
          height: MediaQuery.of(context).size.height * 0.5,
          width: MediaQuery.of(context).size.width * 0.5,
          // color: Colors.red,
          child: Column(
            children: [
              TextField(
                controller: _baseUrlController,
                style: const TextStyle(color: Colors.black),
                decoration: InputDecoration(
                  // border: InputBorder.none,
                  prefixIcon: const Icon(
                    Icons.attach_money_rounded,
                    color: Colors.white30,
                  ),
                  hintText: urlBase,
                  hintStyle: TextStyle(color: Colors.black.withOpacity(0.8)),
                ),
              ),
              const SizedBox(
                height: 30,
              ),
              ElevatedButton.icon(
                  onPressed: () async {
                    await prefs.setString('base_url', _baseUrlController.text);
                    final String? baseUrls = prefs.getString('base_url');
                    Navigator.pushReplacement(context,
                        MaterialPageRoute(builder: (context) => ErrorPage()));
                  },
                  icon: const Icon(Icons.check),
                  label: const Text("Input base Url"))
            ],
          ),
        ),
      ),
    );
  }
}
