import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';

class GeneralSetting extends StatefulWidget {
  const GeneralSetting({Key? key}) : super(key: key);

  @override
  State<GeneralSetting> createState() => _GeneralSettingState();
}

class _GeneralSettingState extends State<GeneralSetting> {
  @override
  Widget build(BuildContext context) {
    final bool isOrderActive = prefs.getBool('isOrderActive') ?? true;
    final bool isAdActive = prefs.getBool('isAdActive') ?? true;
    return Scaffold(
      appBar: AppBar(
        title: const Text("General Setting"),
        backgroundColor: backgroundAppBar,
      ),
      body: SizedBox(
        height: MediaQuery.of(context).size.height,
        child: ListView(
          children: [
            titleHeader(context, "General"),
            listWithSwitch(isOrderActive, "Tampilkan Order", "isOrderActive"),
            listWithSwitch(isAdActive, "Tampilkan Iklan", "isAdActive"),
          ],
        ),
      ),
    );
  }

  Container listWithSwitch(bool isOrderActive, String title, String prefName) {
    return Container(
      margin: const EdgeInsets.only(left: 10, right: 10, top: 15),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            title,
            style: const TextStyle(fontSize: 20, fontWeight: FontWeight.w500),
          ),
          Switch(
              value: isOrderActive,
              onChanged: (bool newValue) async {
                await prefs.setBool(prefName, newValue);
                setState(() {});
              })
        ],
      ),
    );
  }

  Container titleHeader(BuildContext context, String title) {
    return Container(
      color: Colors.black.withOpacity(0.5),
      height: 50,
      width: MediaQuery.of(context).size.width * 1,
      child: Container(
        margin: const EdgeInsets.only(left: 10),
        child: Align(
            alignment: Alignment.centerLeft,
            child: Text(
              title,
              style: const TextStyle(fontWeight: FontWeight.w600, fontSize: 20),
            )),
      ),
    );
  }
}
