import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';
import 'package:second_display/ui/error.dart';

class InputBaseUrl extends StatefulWidget {
  const InputBaseUrl({Key? key}) : super(key: key);

  @override
  State<InputBaseUrl> createState() => _InputBaseUrlState();
}

class _InputBaseUrlState extends State<InputBaseUrl> {
  final _baseUrlController = TextEditingController();
  late String urlBase;
  @override
  void initState() {
    final String? _baseUrls = prefs.getString('base_url');
    urlBase = _baseUrls ?? urlDefault;
    _baseUrlController.text = urlBase;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("Base Url"),
        backgroundColor: backgroundAppBar,
      ),
      body: SingleChildScrollView(
        child: Center(
          child: Container(
            height: MediaQuery.of(context).size.height * 0.5,
            width: MediaQuery.of(context).size.width * 0.5,
            // color: Colors.red,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                const SizedBox(
                  height: 10,
                ),
                const Text(
                  "Base Url",
                  style: TextStyle(fontWeight: FontWeight.w600, fontSize: 20),
                ),
                TextField(
                  controller: _baseUrlController,
                  style: const TextStyle(color: Colors.black),
                  decoration: InputDecoration(
                    // border: InputBorder.none,
                    hintText: urlBase,
                    hintStyle: TextStyle(color: Colors.black.withOpacity(0.8)),
                  ),
                ),
                const SizedBox(
                  height: 30,
                ),
                ElevatedButton.icon(
                    onPressed: () async {
                      await prefs.setString(
                          'base_url', _baseUrlController.text);
                      Navigator.pushReplacement(context,
                          MaterialPageRoute(builder: (context) => ErrorPage()));
                    },
                    icon: const Icon(Icons.check),
                    label: const Text("Input base Url"))
              ],
            ),
          ),
        ),
      ),
    );
  }
}
