import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/ui/settings/about.dart';
import 'package:second_display/ui/settings/general.dart';

import '../settings/input_base_url.dart';

class SettingsMenu extends StatelessWidget {
  const SettingsMenu({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("Setting"),
        backgroundColor: backgroundAppBar,
      ),
      body: Container(
        margin: EdgeInsets.all(MediaQuery.of(context).size.width * 0.02),
        child: Column(
          children: [
            // format listSetting(context, 'nama setting', icon, widget(ketika di pencet mau diarahkan kemana))
            listSetting(context, "General", Icons.settings_applications,
                const GeneralSetting()),
            listSetting(context, "Base Url", Icons.link, const InputBaseUrl()),
            listSetting(context, "About", Icons.android, const AboutSetting()),
          ],
        ),
      ),
    );
  }

  InkWell listSetting(
      BuildContext context, String title, IconData icons, Widget route) {
    return InkWell(
      onTap: () {
        Navigator.push(
          context,
          MaterialPageRoute(
            builder: (BuildContext context) => route,
          ),
        );
      },
      child: listSettingData(context, title, icons),
    );
  }

  Container listSettingData(
      BuildContext context, String title, IconData icons) {
    return Container(
      margin: const EdgeInsets.only(bottom: 15),
      // color: Colors.red,
      child: Row(
        children: [
          Icon(
            icons,
            color: Colors.black,
            size: 25,
          ),
          SizedBox(width: MediaQuery.of(context).size.width * 0.02),
          Text(
            title,
            style: const TextStyle(fontSize: 25, fontWeight: FontWeight.w500),
          )
        ],
      ),
    );
  }
}
