import 'dart:convert';

import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';
import 'package:second_display/models/config_display.dart';
import 'package:second_display/models/order_detail.dart';
import 'package:second_display/models/orders.dart';
import 'package:http/http.dart' as http;
import 'package:flutter/services.dart' as bundel_root;

class Api {
  static Future<CustomerOrders> getOrders() async {
    /// url get data dari midware getby id, need session
    // String apiUrl = getOrdersUrl;

    /// url get data dari midware getorder, no need session
    String apiUrl = getJsonUrl;

    CustomerOrders customerOrdersList = modelCustomerOrder;
    try {
      /// load data dari json local
      // String datas = await bundel_root.rootBundle.loadString('file.json');
      // var jsonObject = jsonDecode(datas);
      /// load data dari json local

      /// load data dari api midware getby id

      // Map data = {
      //   "session_key": "d289c7d6dfc04690b4149b93c91aef8a",
      //   "user_id": "d31d7ad3ba864ea39300cb99c9e2ac3f",
      //   "ignore_lock": "",
      //   "order_id": "a13004c9ba18459586212b7155d7348e"
      // };
      // var bodi = jsonEncode(data);
      // var apiresults = await http.post(Uri.parse(apiUrl), body: bodi);
      // var jsonObject = jsonDecode(apiresults.body);

      /// load data dari api midware getby id

      ///  load data dari midware file json

      Map data = {};
      var bodi = jsonEncode(data);
      var apiresults = await http.post(Uri.parse(apiUrl), body: bodi);
      var jsonObject = jsonDecode(apiresults.body);

      ///  load data dari midwar file json

      List<dynamic> orderDetailCount = (jsonObject
          as Map<dynamic, dynamic>)['data']['order']['order_detail'];
      var jsonMap = jsonObject['data']['order'];
      String orderuserName = jsonMap['id'].substring(0, 5);
      String total = jsonMap['total'];
      String discountAmount = jsonMap['discount_amount'];
      int orderCounts = orderDetailCount.length;
      String subtotal = jsonMap['subtotal'];
      String tax = jsonMap['tax_amount'];
      String pax = jsonMap['pax'].toString();
      String tableName = jsonMap['table_name'];
      String tableSecName = jsonMap['table_section_name'];
      String dateOrder = jsonMap['start_time'];
      String orderusername = jsonMap['order_user_name'];

      customerOrdersList.id = orderuserName;
      customerOrdersList.total = total;
      customerOrdersList.discount_amount = discountAmount;
      customerOrdersList.orderCount = orderCounts;
      customerOrdersList.subtotal = subtotal;
      customerOrdersList.tax = tax;
      customerOrdersList.pax = pax;
      customerOrdersList.table_name = tableName;
      customerOrdersList.table_section_name = tableSecName;
      customerOrdersList.dateOrder = dateOrder;
      customerOrdersList.order_user_name = orderusername;

      return customerOrdersList;
    } catch (e) {
      print(e);
      return customerOrdersList;
    }
  }

  static Future<List<CustomerOrdersDetail>> getOrderDetail() async {
    // String apiUrl = getOrdersUrl;
    String apiUrl = getJsonUrl;
    try {
      List<CustomerOrdersDetail> listOrderDetail = [];

      /// load data dari json local
      // String datas = await bundel_root.rootBundle.loadString('file.json');
      // var jsonObject = jsonDecode(datas);
      /// load data dari json local

      /// load data dari api midware getby id

      // Map data = {
      //   "session_key": "d289c7d6dfc04690b4149b93c91aef8a",
      //   "user_id": "d31d7ad3ba864ea39300cb99c9e2ac3f",
      //   "ignore_lock": "",
      //   "order_id": "a13004c9ba18459586212b7155d7348e"
      // };
      // var bodi = jsonEncode(data);
      // var apiresults = await http.post(Uri.parse(apiUrl), body: bodi);
      // var jsonObject = jsonDecode(apiresults.body);

      /// load data dari api midware getby id

      ///  load data dari midwar file json

      Map data = {};
      var bodi = jsonEncode(data);
      var apiresults = await http.post(Uri.parse(apiUrl), body: bodi);
      var jsonObject = jsonDecode(apiresults.body);

      ///  load data dari midwar file json

      List<dynamic> listDetail = (jsonObject as Map<dynamic, dynamic>)['data']
          ['order']['order_detail'];

      for (int i = 0; i < listDetail.length; i++) {
        listOrderDetail
            .add(CustomerOrdersDetail.createOrderDetail(listDetail[i]));
        // List<dynamic> optionOrderDetail =
        //     (jsonObject as Map<dynamic, dynamic>)['data']['order']
        //         ['order_detail'][i]['order_detail_options'];
        // print(optionOrderDetail.length);
        // if (optionOrderDetail.isNotEmpty) {
        //   for (int j = 0; j < optionOrderDetail.length; j++) {
        //     listOrderDetail.add(
        //         CustomerOrdersDetail(optionName: optionOrderDetail[j]['name']));
        //   }
        // }
      }
      return listOrderDetail;
    } catch (e) {
      print(e);
      return [];
    }
  }

  static Future<List<ConfigDisplay>> getConfigDisplay({url = ''}) async {
    String apiUrl = url + apiUrlConfig;

    try {
      List<ConfigDisplay> configList = [];
      Map data = {};
      var bodi = jsonEncode(data);
      var apiresults = await http.post(Uri.parse(apiUrl), body: bodi);
      if (apiresults.statusCode != 200) {
        navigatorKey.currentState?.pushNamed('/error');
      }
      var jsonObject = jsonDecode(apiresults.body);

      List<dynamic> listConfig = (jsonObject as Map<dynamic, dynamic>)['data'];

      for (int i = 0; i < listConfig.length; i++) {
        configList.add(ConfigDisplay.createConfig(listConfig[i]));
      }

      return configList;
    } catch (e) {
      navigatorKey.currentState?.pushNamed('/error');
      throw Exception("Error to connect API $e");
    }
  }
}
