import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:package_info_plus/package_info_plus.dart';
import 'package:second_display/bloc/config_display_blog.dart';
import 'package:second_display/bloc/order_detail.dart';
import 'package:second_display/bloc/orders_bloc.dart';
import 'package:second_display/ui/error.dart';
import 'package:second_display/ui/settings/input_base_url.dart';
import 'package:second_display/ui/main_page.dart';
import 'package:second_display/ui/settings/menu_setting.dart';
import 'package:second_display/ui/splash.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:url_strategy/url_strategy.dart';

late SharedPreferences prefs;
late String version;
late String buildNumber;
final GlobalKey<NavigatorState> navigatorKey = GlobalKey<NavigatorState>();
void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  PackageInfo packageInfo = await PackageInfo.fromPlatform();
  version = packageInfo.version;
  buildNumber = packageInfo.buildNumber;
  prefs = await SharedPreferences.getInstance();
  setPathUrlStrategy();
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  // This widget is the root of your application.
  @override
  Widget build(BuildContext context) {
    return MultiBlocProvider(
      providers: [
        BlocProvider(create: (_) => OrdersBloc()),
        BlocProvider(create: (_) => OrderDetailBloc()),
        BlocProvider(create: (_) => ConfigDisplayBloc())
      ],
      child: MaterialApp(
        debugShowCheckedModeBanner: false,
        navigatorKey: navigatorKey,
        initialRoute: '/',
        routes: {
          '/': (context) => const Splash(),
          '/main': (context) => const MainPage(),
          '/error': (context) => ErrorPage(),
          '/inputbase': (context) => const InputBaseUrl(),
          '/settings-menu': (context) => const SettingsMenu()
        },
      ),
    );
  }
}
