import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';

class ErrorPage extends StatelessWidget {
  ErrorPage({Key? key}) : super(key: key);

  final String? baseUrls = prefs.getString('base_url');
  final String ipAddress = prefs.getString('ipAddress') ?? "Not Found";
  final String wifiName = prefs.getString('wifiName') ?? "Not Found";
  @override
  Widget build(BuildContext context) {
    return Container(
      color: Colors.white,
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          SizedBox(
              width: MediaQuery.of(context).size.width * 0.2,
              height: MediaQuery.of(context).size.width * 0.2,
              child: const Image(
                image: AssetImage("assets/images/error.png"),
                fit: BoxFit.cover,
              )),
          SizedBox(
            height: MediaQuery.of(context).size.height * 0.05,
          ),
          Text(
            "Error connect to server, Need to refresh and check the server",
            style: TextStyle(
                fontSize: MediaQuery.of(context).size.height * 0.03,
                fontWeight: FontWeight.w500,
                color: Colors.black,
                decoration: TextDecoration.none),
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Text(
                "Your Base Url: ",
                style: TextStyle(
                    fontSize: MediaQuery.of(context).size.height * 0.02,
                    fontWeight: FontWeight.w500,
                    color: Colors.black,
                    decoration: TextDecoration.none),
              ),
              Text(
                baseUrls ?? urlDefault,
                style: TextStyle(
                    fontSize: MediaQuery.of(context).size.height * 0.02,
                    fontWeight: FontWeight.w500,
                    color: Colors.red,
                    decoration: TextDecoration.none),
              ),
            ],
          ),
          (ipAddress != 'Not Found')
              ? Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(
                      "Your IP Address: ",
                      style: TextStyle(
                          fontSize: MediaQuery.of(context).size.height * 0.02,
                          fontWeight: FontWeight.w500,
                          color: Colors.black,
                          decoration: TextDecoration.none),
                    ),
                    Text(
                      ipAddress,
                      style: TextStyle(
                          fontSize: MediaQuery.of(context).size.height * 0.02,
                          fontWeight: FontWeight.w500,
                          color: Colors.red,
                          decoration: TextDecoration.none),
                    ),
                  ],
                )
              : const SizedBox(
                  width: 0,
                  height: 0,
                ),
          (wifiName != 'Not Found')
              ? Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Text(
                      "WIFI SSID: ",
                      style: TextStyle(
                          fontSize: MediaQuery.of(context).size.height * 0.02,
                          fontWeight: FontWeight.w500,
                          color: Colors.black,
                          decoration: TextDecoration.none),
                    ),
                    Text(
                      wifiName,
                      style: TextStyle(
                          fontSize: MediaQuery.of(context).size.height * 0.02,
                          fontWeight: FontWeight.w500,
                          color: Colors.red,
                          decoration: TextDecoration.none),
                    ),
                  ],
                )
              : const SizedBox(
                  width: 0,
                  height: 0,
                ),
          SizedBox(
            height: MediaQuery.of(context).size.height * 0.05,
          ),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              ElevatedButton.icon(
                  onPressed: () {
                    Navigator.pushReplacementNamed(context, '/');
                  },
                  icon: const Icon(Icons.refresh_sharp),
                  label: const Text("Connect")),
              SizedBox(
                width: MediaQuery.of(context).size.width * 0.01,
              ),
              ElevatedButton.icon(
                  onPressed: () {
                    Navigator.pushNamed(context, '/inputbase');
                  },
                  icon: const Icon(Icons.input_outlined),
                  label: const Text("Input base Url"))
            ],
          )
        ],
      ),
    );
  }
}
