import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';

class AboutSetting extends StatefulWidget {
  const AboutSetting({Key? key}) : super(key: key);

  @override
  State<AboutSetting> createState() => _AboutSettingState();
}

class _AboutSettingState extends State<AboutSetting> {
  final String ipAddress = prefs.getString('ipAddress') ?? 'Not Found';
  final String wifiName = prefs.getString('wifiName') ?? 'Not Found';

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("About"),
        backgroundColor: backgroundAppBar,
      ),
      body: Column(
        children: [
          titleHeader(context, "Device"),
          listAbout(context, 'IP Address', ipAddress),
          listAbout(context, 'App Version', version),
          listAbout(context, 'Build Number', buildNumber),
          listAbout(context, 'Wifi SSID', wifiName),
        ],
      ),
    );
  }

  Container titleHeader(BuildContext context, String title) {
    return Container(
      color: Colors.black.withOpacity(0.5),
      height: 40,
      width: MediaQuery.of(context).size.width * 1,
      child: Container(
        margin: EdgeInsets.only(left: 10),
        child: Align(alignment: Alignment.centerLeft, child: Text(title)),
      ),
    );
  }

  Container listAbout(BuildContext context, String kiri, String kanan) {
    return Container(
      margin: const EdgeInsets.only(left: 10, top: 10, right: 10),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            kiri,
            style: const TextStyle(fontSize: 20, fontWeight: FontWeight.w500),
          ),
          Text(
            kanan,
            style: const TextStyle(fontSize: 20, fontWeight: FontWeight.w300),
          ),
        ],
      ),
    );
  }
}
