import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';

class GeneralSetting extends StatefulWidget {
  const GeneralSetting({Key? key}) : super(key: key);

  @override
  State<GeneralSetting> createState() => _GeneralSettingState();
}

class _GeneralSettingState extends State<GeneralSetting> {
  @override
  Widget build(BuildContext context) {
    final bool? isOrderActive = prefs.getBool('isOrderActive');
    final bool? isAdActive = prefs.getBool('isAdActive');
    return Scaffold(
      appBar: AppBar(
        title: const Text("General Setting"),
        backgroundColor: backgroundAppBar,
      ),
      body: Column(
        children: [
          Container(
            color: Colors.black.withOpacity(0.5),
            height: 50,
            width: MediaQuery.of(context).size.width * 1,
            child: Container(
              margin: EdgeInsets.only(left: 10),
              child: const Align(
                  alignment: Alignment.centerLeft, child: Text("General")),
            ),
          ),
          Container(
            margin: const EdgeInsets.only(left: 10, right: 10),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  "Tampilkan Order",
                  style: TextStyle(
                      fontSize: MediaQuery.of(context).size.height * 0.025,
                      fontWeight: FontWeight.w500),
                ),
                Switch(
                    value: (isOrderActive == null) ? true : isOrderActive,
                    onChanged: (bool newValue) async {
                      await prefs.setBool('isOrderActive', newValue);
                      setState(() {});
                    })
              ],
            ),
          ),
          Container(
            margin: const EdgeInsets.only(left: 10, right: 10),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  "Tampilkan Iklan",
                  style: TextStyle(
                      fontSize: MediaQuery.of(context).size.height * 0.025,
                      fontWeight: FontWeight.w500),
                ),
                Switch(
                    value: (isAdActive == null) ? true : isAdActive,
                    onChanged: (bool newValue) async {
                      await prefs.setBool('isAdActive', newValue);
                      setState(() {});
                    })
              ],
            ),
          )
        ],
      ),
    );
  }
}
