import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/ui/settings/about.dart';
import 'package:second_display/ui/settings/general.dart';

import '../settings/input_base_url.dart';

class SettingsMenu extends StatelessWidget {
  const SettingsMenu({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("Setting"),
        backgroundColor: backgroundAppBar,
      ),
      body: Container(
        margin: EdgeInsets.all(MediaQuery.of(context).size.width * 0.02),
        child: Column(
          children: [
            InkWell(
              onTap: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder: (BuildContext context) => const GeneralSetting(),
                  ),
                );
              },
              child: Row(
                children: [
                  const Icon(
                    Icons.settings_applications,
                    color: Colors.black,
                    size: 25,
                  ),
                  SizedBox(width: MediaQuery.of(context).size.width * 0.02),
                  const Text(
                    "General",
                    style: TextStyle(fontSize: 25, fontWeight: FontWeight.w500),
                  )
                ],
              ),
            ),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.02,
            ),
            InkWell(
              onTap: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder: (BuildContext context) => const InputBaseUrl(),
                  ),
                );
              },
              child: Row(
                children: [
                  const Icon(
                    Icons.link,
                    color: Colors.black,
                    size: 25,
                  ),
                  SizedBox(width: MediaQuery.of(context).size.width * 0.02),
                  const Text(
                    "Base Url",
                    style: TextStyle(fontSize: 25, fontWeight: FontWeight.w500),
                  )
                ],
              ),
            ),
            SizedBox(
              height: MediaQuery.of(context).size.height * 0.02,
            ),
            InkWell(
              onTap: () {
                Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder: (BuildContext context) => const AboutSetting(),
                  ),
                );
              },
              child: Container(
                child: Row(
                  children: [
                    const Icon(
                      Icons.android,
                      color: Colors.black,
                      size: 25,
                    ),
                    SizedBox(width: MediaQuery.of(context).size.width * 0.02),
                    const Text(
                      "About",
                      style:
                          TextStyle(fontSize: 25, fontWeight: FontWeight.w500),
                    )
                  ],
                ),
              ),
            )
          ],
        ),
      ),
    );
  }
}
