import 'package:second_display/api/api.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/models/orders.dart';
import 'package:bloc/bloc.dart';

class OrdersBloc extends Cubit<CustomerOrders> {
  OrdersBloc() : super(modelCustomerOrder);

  Future<CustomerOrders> getData() async {
    return await Api.getOrders();
  }

  void getOrderList() {
    getData().then((value) {
      emit(value);
    });
  }
}
