import 'package:carousel_slider/carousel_slider.dart';
import 'package:flutter/material.dart';
import 'package:second_display/helper/config.dart';

class CarouselIndicator extends StatefulWidget {
  final Color backgroundColor;
  const CarouselIndicator({Key? key, required this.backgroundColor})
      : super(key: key);
  @override
  State<CarouselIndicator> createState() => _CarouselIndicatorState();
}

class _CarouselIndicatorState extends State<CarouselIndicator> {
  int _current = 0;
  final CarouselController _controller = CarouselController();
  final List<Widget> imageSliders = imglist
      .map((item) => Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Container(
                // padding: EdgeInsets.only(top: MediaQuery.of(context).size.height *),
                child: Container(
                  // margin: const EdgeInsets.all(5.0),
                  child: ClipRRect(
                      borderRadius:
                          const BorderRadius.all(Radius.circular(5.0)),
                      child: Stack(
                        children: <Widget>[
                          Image.network(item,
                              fit: BoxFit.cover, width: double.infinity),
                          Positioned(
                            bottom: 0.0,
                            left: 0.0,
                            right: 0.0,
                            child: Container(
                              decoration: const BoxDecoration(
                                gradient: LinearGradient(
                                  colors: [
                                    Color.fromARGB(200, 0, 0, 0),
                                    Color.fromARGB(0, 0, 0, 0)
                                  ],
                                  begin: Alignment.bottomCenter,
                                  end: Alignment.topCenter,
                                ),
                              ),
                            ),
                          ),
                        ],
                      )),
                ),
              ),
            ],
          ))
      .toList();

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: Container(
        color: widget.backgroundColor,
        child: Column(children: [
          Expanded(
            child: CarouselSlider(
              items: imageSliders,
              carouselController: _controller,
              options: CarouselOptions(
                  autoPlay: (imglist.length > 1) ? true : false,
                  autoPlayInterval: const Duration(seconds: 5),
                  enlargeCenterPage: true,
                  viewportFraction: 1.0,
                  height: MediaQuery.of(context).size.height,
                  onPageChanged: (index, reason) {
                    setState(() {
                      _current = index;
                    });
                  }),
            ),
          ),
          (imgLists!.length > 1)
              ? Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: imglist.asMap().entries.map((entry) {
                    return GestureDetector(
                      onTap: () => _controller.animateToPage(entry.key),
                      child: Container(
                          width: MediaQuery.of(context).size.width * 0.012,
                          height: MediaQuery.of(context).size.height * 0.012,
                          margin: EdgeInsets.symmetric(
                            vertical:
                                MediaQuery.of(context).size.height * 0.008,
                            horizontal:
                                MediaQuery.of(context).size.width * 0.0004,
                          ),
                          decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: Colors.white.withOpacity(
                                  _current == entry.key ? 0.8 : 0.4))),
                    );
                  }).toList(),
                )
              : const SizedBox(height: 0),
        ]),
      ),
    );
  }
}
