import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:second_display/bloc/config_display_blog.dart';
import 'package:second_display/bloc/order_detail.dart';
import 'package:second_display/bloc/orders_bloc.dart';
import 'package:second_display/main.dart';
import 'package:second_display/models/config_display.dart';
import 'package:second_display/ui/carousel.dart';
import 'package:second_display/ui/orders.dart';
import 'package:second_display/ui/video_promotion.dart';
import 'package:second_display/ui/youtube.dart';

// ignore: must_be_immutable
class MainPage extends StatelessWidget {
  bool isOrderActive = true;
  MainPage({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    context.read<OrdersBloc>().getOrderList();
    context.read<OrderDetailBloc>().getOrderDetailList();
    return SafeArea(
      child: MaterialApp(
        debugShowCheckedModeBanner: false,
        home:
            Scaffold(body: BlocBuilder<ConfigDisplayBloc, List<ConfigDisplay>>(
          builder: (context, configState) {
            if (configState.isEmpty) {
              navigatorKey.currentState?.pushNamed('/error');
            }
            int valueIntBackgroundColorCarouselVideo = int.parse(
                configState[0].backgroundColorCarouselVideo,
                radix: 16);
            final Color colorBackgroundCarouselandVideo =
                Color(valueIntBackgroundColorCarouselVideo);

            int valueIntTextColor =
                int.parse(configState[0].textColor, radix: 16);
            final Color textColor = Color(valueIntTextColor);

            int valueIntBackgroundColorOrder =
                int.parse(configState[0].backgroundColorOrder, radix: 16);
            final Color backgroundColorOrder =
                Color(valueIntBackgroundColorOrder);

            List<String> images = [];
            var imageString = configState[0].images.split(';');
            for (int i = 0; i < imageString.length; i++) {
              images.add(imageString[i].trim());
            }
            prefs.setStringList("imageList", images);
            return Row(
              children: [
                (configState[0].mediaType == 'video')
                    ? Container(
                        height: MediaQuery.of(context).size.height,
                        width: (isOrderActive)
                            ? MediaQuery.of(context).size.width * 0.6
                            : MediaQuery.of(context).size.width * 1,
                        color: colorBackgroundCarouselandVideo,
                        // color: Colors.white,
                        child: VideoPromotion(
                            videoUrl: configState[0].videoPromotionUrl),
                      )
                    : (configState[0].mediaType == 'image')
                        ? Container(
                            height: MediaQuery.of(context).size.height,
                            width: (isOrderActive)
                                ? MediaQuery.of(context).size.width * 0.6
                                : MediaQuery.of(context).size.width * 1,
                            child: CarouselIndicator(
                                backgroundColor:
                                    colorBackgroundCarouselandVideo),
                          )
                        : Container(
                            height: MediaQuery.of(context).size.height,
                            width: (isOrderActive)
                                ? MediaQuery.of(context).size.width * 0.6
                                : MediaQuery.of(context).size.width * 1,
                            child: YoutubeVideo(
                                backgroundColor:
                                    colorBackgroundCarouselandVideo,
                                youtubeId: configState[0].youtubeId,
                                isOrderActive: isOrderActive),
                          ),
                (isOrderActive)
                    ? Container(
                        height: MediaQuery.of(context).size.height,
                        width: MediaQuery.of(context).size.width * 0.4,
                        color: backgroundColorOrder,
                        // decoration: const BoxDecoration(
                        //     gradient: LinearGradient(
                        //   begin: Alignment.topLeft,
                        //   end: Alignment.bottomRight,
                        //   colors: [
                        //     Colors.blue,
                        //     Colors.white,
                        //   ],
                        // )),
                        child: OrderPage(textColor: textColor),
                      )
                    : const SizedBox(height: 0, width: 0)
              ],
            );
          },
        )),
      ),
    );
  }
}
