import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:second_display/bloc/order_detail.dart';
import 'package:second_display/bloc/orders_bloc.dart';
import 'package:second_display/models/order_detail.dart';
import 'package:second_display/models/orders.dart';
import 'package:intl/intl.dart';

class OrderPage extends StatelessWidget {
  final Color textColor;
  const OrderPage({Key? key, required this.textColor}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<OrdersBloc, CustomerOrders>(
      builder: (context, list) {
        var totalAmount = double.tryParse(list.total) ?? 0;
        var discountAmount = double.tryParse(list.discount_amount) ?? 0;
        var subTotalAmount = double.tryParse(list.subtotal) ?? 0;
        var taxAmount = double.tryParse(list.tax) ?? 0;
        var totalAmountText = formatCurrency().format(totalAmount);
        var discountAmountText = formatCurrency().format(discountAmount);
        var subTotalAmountText = formatCurrency().format(subTotalAmount);
        var taxAmountText = formatCurrency().format(taxAmount);
        String? timeOrder;
        if (list.dateOrder != '') {
          var dateFormat = DateFormat("yyyy-MM-ddTHH:mm:ss")
              .parse(list.dateOrder, true)
              .toLocal();
          var afterFormat =
              DateFormat('dd MMM yyyy  HH:mm:ss').format(dateFormat);
          timeOrder = afterFormat.toString();
        } else {
          timeOrder = '';
        }

        return Container(
          // color: Colors.black.withOpacity(0.8),
          margin: EdgeInsets.fromLTRB(
              MediaQuery.of(context).size.width * 0.02,
              MediaQuery.of(context).size.height * 0.02,
              MediaQuery.of(context).size.width * 0.02,
              MediaQuery.of(context).size.height * 0.02),
          child: Column(
            children: [
              Container(
                // color: Colors.red,
                height: MediaQuery.of(context).size.height * 0.08,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Text(
                          list.order_user_name,
                          style: TextStyle(
                              fontSize:
                                  MediaQuery.of(context).size.height * 0.04,
                              color: textColor),
                        ),
                      ],
                    )
                  ],
                ),
              ),
              Container(
                // color: Colors.green,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Column(
                      children: [
                        topList(context, "Order ID: " + list.id.toUpperCase(),
                            timeOrder),
                        topList(context, list.table_name,
                            "Tabel Section: " + list.table_section_name),
                      ],
                    )
                  ],
                ),
              ),
              Expanded(
                  child: Divider(
                color: Colors.white,
                height: MediaQuery.of(context).size.height * 0.01,
                thickness: MediaQuery.of(context).size.height * 0.003,
              )),
              Container(
                // color: Colors.blue,
                height: MediaQuery.of(context).size.height * 0.5,
                child: BlocBuilder<OrderDetailBloc, List<CustomerOrdersDetail>>(
                  builder: (context, detailOrder) {
                    return ListView.builder(
                      itemCount: detailOrder.length,
                      itemBuilder: (context, i) {
                        var optionStr = detailOrder[i].optionOrder;
                        var orderOptionDetail = optionStr.split(';');
                        var amountEachOrder =
                            double.tryParse(detailOrder[i].total) ?? 0;
                        var amountEachOrderText =
                            formatCurrency().format(amountEachOrder);
                        return Row(
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            Container(
                              margin: EdgeInsets.only(
                                  bottom: MediaQuery.of(context).size.height *
                                      0.01),
                              child: Column(
                                children: [
                                  Container(
                                    // color: Colors.white,
                                    height: MediaQuery.of(context).size.height *
                                        0.05,
                                    margin: EdgeInsets.only(
                                        top:
                                            MediaQuery.of(context).size.height *
                                                0.005,
                                        bottom:
                                            MediaQuery.of(context).size.height *
                                                0),
                                    child: Row(
                                      children: [
                                        listOforder(
                                            context,
                                            Alignment.centerLeft,
                                            double.tryParse(
                                                        detailOrder[i].quantity)
                                                    .toString() +
                                                " x " +
                                                detailOrder[i].name),
                                        listOforder(
                                            context,
                                            Alignment.centerRight,
                                            amountEachOrderText)
                                      ],
                                    ),
                                  ),
                                  for (int i = 0;
                                      i < orderOptionDetail.length;
                                      i++)
                                    Container(
                                      // color: Colors.green,
                                      height:
                                          MediaQuery.of(context).size.height *
                                              0.02,
                                      margin: EdgeInsets.only(
                                          top: MediaQuery.of(context)
                                                  .size
                                                  .height *
                                              0.000,
                                          bottom: MediaQuery.of(context)
                                                  .size
                                                  .height *
                                              0.001),
                                      child: Row(
                                        children: [
                                          listOforderOption(
                                              context,
                                              Alignment.topLeft,
                                              orderOptionDetail[i].trim()),
                                          listOforderOption(context,
                                              Alignment.centerRight, '')
                                        ],
                                      ),
                                    ),
                                ],
                              ),
                            )
                          ],
                        );
                      },
                    );
                  },
                ),
              ),
              Expanded(
                  child: Divider(
                color: Colors.white,
                height: MediaQuery.of(context).size.height * 0.01,
                thickness: MediaQuery.of(context).size.height * 0.003,
              )),
              SizedBox(height: MediaQuery.of(context).size.height * 0.01),
              Container(
                // color: Colors.green,
                height: MediaQuery.of(context).size.height * 0.25,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    BlocBuilder<OrderDetailBloc, List<CustomerOrdersDetail>>(
                      builder: (context, itemTotal) {
                        late int totalQuantity = 0;
                        for (int i = 0; i < itemTotal.length; i++) {
                          var quantity =
                              double.tryParse(itemTotal[i].quantity) ?? 0;
                          totalQuantity = totalQuantity + quantity.toInt();
                        }
                        return Column(
                          children: [
                            // Text(
                            //   "Total Rincian",
                            //   style: TextStyle(
                            //       color: textColor,
                            //       fontSize:
                            //           MediaQuery.of(context).size.height * 0.03),
                            // ),
                            SizedBox(
                                height:
                                    MediaQuery.of(context).size.height * 0.01),
                            listTotalRincian(
                                context, "Subtotal", subTotalAmountText + ",-"),
                            listTotalRincian(
                                context, "Diskon", discountAmountText + ",-"),
                            listTotalRincian(
                                context, "Pajak", taxAmountText + ",-"),
                            listTotalRincian(context, "Total Item",
                                totalQuantity.toString()),
                            SizedBox(
                                height:
                                    MediaQuery.of(context).size.height * 0.02),
                            listTotalRincian(
                                context, "Total", totalAmountText + ",-"),
                          ],
                        );
                      },
                    )
                  ],
                ),
              )
            ],
          ),
        );
      },
    );
  }

  Container topList(BuildContext context, String kiri, String kanan) {
    return Container(
      // color: Colors.green,
      margin: EdgeInsets.only(
          top: MediaQuery.of(context).size.height * 0.0001,
          bottom: MediaQuery.of(context).size.height * 0.0001),
      child: Row(
        children: [
          Container(
            // color: Colors.white,
            height: MediaQuery.of(context).size.height * 0.02,
            width: MediaQuery.of(context).size.width * 0.13,
            child: Align(
              alignment: Alignment.centerLeft,
              child: Text(
                kiri,
                style: TextStyle(
                    fontSize: MediaQuery.of(context).size.height * 0.015,
                    color: textColor.withOpacity(0.5)),
              ),
            ),
          ),
          Container(
            // color: Colors.white,
            height: MediaQuery.of(context).size.height * 0.02,
            width: MediaQuery.of(context).size.width * 0.13,
            child: Align(
              alignment: Alignment.centerRight,
              child: Text(
                kanan,
                style: TextStyle(
                    fontSize: MediaQuery.of(context).size.height * 0.015,
                    color: textColor.withOpacity(0.5)),
              ),
            ),
          ),
        ],
      ),
    );
  }

  NumberFormat formatCurrency() =>
      NumberFormat.currency(locale: 'id', symbol: 'Rp ', decimalDigits: 0);

  Container listTotalRincian(
      BuildContext context, String textKiri, String textKanan) {
    return Container(
      // color: Colors.white,
      height: MediaQuery.of(context).size.height * 0.03,
      margin: EdgeInsets.only(
          top: MediaQuery.of(context).size.height * 0.0001,
          bottom: MediaQuery.of(context).size.height * 0.0001),
      child: Row(
        children: [
          listOforder(context, Alignment.centerLeft, textKiri),
          listOforder(context, Alignment.centerRight, textKanan)
        ],
      ),
    );
  }

  Container listOforder(BuildContext context, Alignment align, String text) {
    return Container(
      // color: Colors.white,
      height: MediaQuery.of(context).size.height * 0.06,
      width: MediaQuery.of(context).size.width * 0.13,
      child: Align(
        alignment: align,
        child: Text(
          text,
          overflow: TextOverflow.ellipsis,
          maxLines: 2,
          style: TextStyle(
              fontSize: MediaQuery.of(context).size.height * 0.02,
              color: textColor),
        ),
      ),
    );
  }

  Container listOforderOption(
      BuildContext context, Alignment align, String text) {
    return Container(
      // color: Colors.white,
      height: MediaQuery.of(context).size.height * 0.05,
      width: MediaQuery.of(context).size.width * 0.13,
      child: Align(
        alignment: align,
        child: Text(
          text,
          style: TextStyle(
              fontSize: MediaQuery.of(context).size.height * 0.015,
              color: textColor.withOpacity(0.7)),
        ),
      ),
    );
  }
}
