

import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:loading_animations/loading_animations.dart';
import 'package:second_display/api/api.dart';
import 'package:second_display/bloc/config_display_blog.dart';
import 'package:second_display/helper/config.dart';
import 'package:second_display/main.dart';
import 'package:second_display/models/config_display.dart';
import 'package:second_display/ui/main_page.dart';

class Splash extends StatefulWidget {
  const Splash({Key? key}) : super(key: key);

  @override
  State<Splash> createState() => _SplashState();
}

Future<List<ConfigDisplay>> config(String url) async {
  List<ConfigDisplay> apiConfigs = [];
  try {
    var apiConfig = await Api.getConfigDisplay(url: url);
    apiConfigs = apiConfig;
    return apiConfigs;
  } catch (e) {
    return apiConfigs;
  }
}

class _SplashState extends State<Splash> {
  @override
  void initState() {
    String? base_urlapi = prefs.getString('base_url');
    config(base_urlapi ?? urlDefault).then((value) async {
      context
          .read<ConfigDisplayBloc>()
          .getConfigDisplay(base_urlapi ?? urlDefault);
      await prefs.setString('background_color_carousel_video',
          value[0].backgroundColorCarouselVideo);
      await prefs.setString('text_color', value[0].textColor);
      await prefs.setString(
          'backgroundColorOrder', value[0].backgroundColorOrder);
      await prefs.setString('mediaType', value[0].mediaType);
      await prefs.setString('youtubeId', value[0].youtubeId);
      await prefs.setString('videoPromotionUrl', value[0].videoPromotionUrl);
      await prefs.setString('images', value[0].images);

      Future.delayed(const Duration(seconds: 3), () {
        Navigator.push(context, MaterialPageRoute(builder: (_) => MainPage()));
      });
    });

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      mainAxisAlignment: MainAxisAlignment.center,
      children: [
        Text(
          "Please wait",
          style: TextStyle(
              fontSize: MediaQuery.of(context).size.height * 0.03,
              fontWeight: FontWeight.w500,
              color: Colors.black,
              decoration: TextDecoration.none),
        ),
        LoadingBumpingLine.circle(
          size: MediaQuery.of(context).size.height * 0.1,
          backgroundColor: Colors.black,
        )
      ],
    );
  }
}
