import 'package:flutter/material.dart';
import 'package:loading_animations/loading_animations.dart';
import 'package:video_player/video_player.dart';

class VideoPromotion extends StatefulWidget {
  final String videoUrl;
  const VideoPromotion({Key? key, required this.videoUrl}) : super(key: key);

  @override
  State<VideoPromotion> createState() => _VideoPromotionState();
}

class _VideoPromotionState extends State<VideoPromotion> {
  VideoPlayerController? _controller;
  @override
  void initState() {
    _controller = VideoPlayerController.network(widget.videoUrl)
      ..setLooping(true)
      ..initialize().then((_) {
        // Ensure the first frame is shown after the video is initialized, even before the play button has been pressed.
        setState(() {});
      });

    _controller!.setVolume(0);
    _controller!.play();

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Container(
          // color: Colors.green,
          // margin: EdgeInsets.fromLTRB(
          //     MediaQuery.of(context).size.width * 0.05,
          //     MediaQuery.of(context).size.height * 0.1,
          //     MediaQuery.of(context).size.width * 0.05,
          //     MediaQuery.of(context).size.height * 0.1),
          child: _controller!.value.isInitialized
              ? AspectRatio(
                  aspectRatio: _controller!.value.aspectRatio,
                  child: VideoPlayer(_controller!),
                )
              : Center(
                  child: Container(
                    child: LoadingBumpingLine.circle(
                      size: MediaQuery.of(context).size.height * 0.1,
                      backgroundColor: Colors.black,
                    ),
                  ),
                )),
    );
  }
}
