import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
// import 'package:flutter_html/flutter_html.dart';
import 'package:youtube_player_iframe/youtube_player_iframe.dart';

class YoutubeVideo extends StatefulWidget {
  final String youtubeId;
  final Color backgroundColor;
  final bool isOrderActive;
  const YoutubeVideo(
      {Key? key,
      required this.youtubeId,
      required this.backgroundColor,
      required this.isOrderActive})
      : super(key: key);

  @override
  State<YoutubeVideo> createState() => _YoutubeVideoState();
}

class _YoutubeVideoState extends State<YoutubeVideo> {
  late YoutubePlayerController _controller;

  @override
  void initState() {
    super.initState();
    _controller = YoutubePlayerController(
      initialVideoId: widget.youtubeId,
      params: YoutubePlayerParams(
        playlist: [
          widget.youtubeId,
        ],
        loop: true,
        mute: true,
        enableCaption: false,
        startAt: const Duration(minutes: 0, seconds: 0),
        showControls: false,
        showFullscreenButton: false,
        desktopMode: true,
        privacyEnhanced: true,
        useHybridComposition: true,
      ),
    );
    _controller.onEnterFullscreen = () {
      SystemChrome.setPreferredOrientations([
        DeviceOrientation.landscapeLeft,
        DeviceOrientation.landscapeRight,
      ]);
    };
    _controller.onExitFullscreen = () {};
  }

  @override
  Widget build(BuildContext context) {
    var widthYoutbe = (widget.isOrderActive)
        ? MediaQuery.of(context).size.width * 0.6
        : MediaQuery.of(context).size.width * 1;
    var heighYoutbe = MediaQuery.of(context).size.height;
    // return Center(
    //   child: Container(
    //     color: widget.backgroundColor,
    //     child: Html(
    //       data:
    //           '<iframe width="$widthYoutbe" height="$heighYoutbe" src="https://www.youtube.com/embed/${widget.youtubeId}?rel=0&autoplay=1&mute=1&enablejsapi=1&controls=0&loop=1&playlist=${widget.youtubeId}&autohide=1&modestbranding=1" frameborder="0" clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>',
    //     ),
    //   ),
    // );
    return YoutubePlayerControllerProvider(
        controller: _controller,
        child: Container(
          width: widthYoutbe,
          height: heighYoutbe,
          child: YoutubePlayerControllerProvider(
            // Provides controller to all the widget below it.
            controller: _controller,
            child: const YoutubePlayerIFrame(
              aspectRatio: 16 / 9,
            ),
          ),
        ));
  }
}
