# permissions.py

from rest_framework import permissions

class MemberReadOnlyPermission(permissions.BasePermission):
    message = "Anda tidak memiliki izin untuk melakukan operasi ini."

    def has_permission(self, request, view):
        # Hanya izinkan metode GET (read) untuk pengguna dengan peran 'member'
        if request.user.is_member and request.method in permissions.SAFE_METHODS:
            return True
        return False

class LibrarianPermission(permissions.BasePermission):
    message = "Anda tidak memiliki izin untuk melakukan operasi ini."

    def has_permission(self, request, view):
        # Pastikan pengguna terotentikasi sebelum mengakses atribut is_librarian
        if request.user.is_authenticated:
            return request.user.is_librarian
        return False