
from django.urls import include, path
from api import views
from rest_framework.urlpatterns import format_suffix_patterns
from rest_framework.authtoken.views import obtain_auth_token
from rest_framework_simplejwt.views import (
    TokenObtainPairView,
    TokenRefreshView,
    TokenVerifyView
)

urlpatterns = [

    # path('login/', obtain_auth_token, name='login'),

    path('register-member/', views.MemberRegistrationAPIView.as_view(), name='api_register_member'),
    path('register-librarian/', views.LibrarianRegistrationAPIView.as_view(), name='api_register_librarian'),

    path('category/', views.CategoryList.as_view()),
    path('category/<int:pk>/', views.CategoryDetail.as_view()),

    path('token/', TokenObtainPairView.as_view(), name='token_obtain_pair'),
    path('token/refresh/', TokenRefreshView.as_view(), name='token_refresh'),
    path('token/verify/', TokenVerifyView.as_view(), name='token_verify'),

    path('book/', views.BookListNonAuth.as_view()),
    path('auth/book/', views.BookList.as_view()),
    path('book/search/', views.BookSearchView.as_view(), name='book-search-api'),
    path('book/by-year/<int:year>/', views.BookListByYear.as_view(), name='book-list-by-year'),
    path('book/by-category/<str:category>/', views.BookListByCategory.as_view(), name='book-list-by-category'),
    path('book/by-custom/<int:year>/<str:category>/', views.BookListByYearAndCategory.as_view(), name='book-list-custom'),
    path('book/<int:pk>/', views.BookDetail.as_view()),

    path('member/', views.MemberList.as_view()),
    path('member-login/', views.MemberLoginView.as_view(), name='member-login'),
    path('member-logout/', views.MemberLogoutView.as_view(), name='member-logout-api'),
    path('member/<int:pk>/', views.MemberDetail.as_view()),

    path('librarian/', views.LibrarianList.as_view()),
    path('librarian-login/', views.LibrarianLoginView.as_view(), name='librarian-login'),
    path('librarian-logout/', views.LibrarianLogoutView.as_view(), name='member-logout-api'),
    path('librarian/<int:pk>/', views.LibrarianDetail.as_view()),

    path('bookloan/', views.BookLoanList.as_view()),
    path('bookloan/<int:pk>/', views.BookLoanDetail.as_view()),
    path('member/book-loan/', views.LoanSelectedBook.as_view()),
    path('member/list-book-loan/', views.BookLoanViewSet.as_view({'get': 'list'})),
    path('member/book-loan/<int:id>/', views.LoanSelectedBookById.as_view()),

    path('near-outstanding-books/', views.NearOutstandingLoansAPIView.as_view(), name='near-outstanding-books-api'),
    path('overdue-books/', views.OverdueLoansAPIView.as_view(), name='overdue-books-api'),

    path('change-password/', views.ChangePasswordView.as_view(), name='change-password-api'),

    path('change-profile/', views.ChangeProfileView.as_view(), name='change-profile-api'),

]

# urlpatterns = format_suffix_patterns(urlpatterns)