from functools import wraps
from django.shortcuts import redirect

def librarian_required(view_func):
    @wraps(view_func)
    def _wrapped_view(request, *args, **kwargs):
        # Gantilah dengan mekanisme otentikasi sesuai kebutuhan Anda
        if request.user.is_authenticated and request.user.is_librarian == True:
            return view_func(request, *args, **kwargs)
        else:
            return redirect('unauthorized')
    return _wrapped_view